/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.test.authentication.http.jetty;

import java.net.URL;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.webapp.WebAppContext;
import org.junit.Assert;
import org.junit.Test;
import org.picketbox.http.filters.DelegatingSecurityFilter;
import org.picketbox.test.authentication.http.jetty.HTTPDigestConfigurationProvider;
import org.picketbox.test.http.jetty.EmbeddedWebServerBase;

public class DelegatingSecurityFilterHTTPBasicUnitTestCase
extends EmbeddedWebServerBase {
    String urlStr = "http://localhost:11080/auth/";

    @Override
    protected void establishUserApps() {
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        if (tcl == null) {
            tcl = this.getClass().getClassLoader();
        }
        String WEBAPPDIR = "auth/webapp";
        String CONTEXTPATH = "/auth";
        URL warUrl = tcl.getResource("auth/webapp");
        String warUrlString = warUrl.toExternalForm();
        WebAppContext webapp = this.createWebApp("/auth", warUrlString);
        this.server.setHandler((Handler)webapp);
        System.setProperty("picketbox.username", "Aladdin");
        System.setProperty("picketbox.credential", "Open Sesame");
        FilterHolder filterHolder = new FilterHolder(DelegatingSecurityFilter.class);
        webapp.setInitParameter("org.picketbox.authentication", "BASIC");
        webapp.setInitParameter("org.picketbox.configuration.provider", HTTPDigestConfigurationProvider.class.getName());
        ServletHandler servletHandler = new ServletHandler();
        servletHandler.addFilter(filterHolder, this.createFilterMapping("/", filterHolder));
        webapp.setServletHandler(servletHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicAuth() throws Exception {
        URL url = new URL(this.urlStr);
        DefaultHttpClient httpclient = null;
        try {
            String user = "Aladdin";
            String pass = "Open Sesame";
            httpclient = new DefaultHttpClient();
            httpclient.getCredentialsProvider().setCredentials(new AuthScope(url.getHost(), url.getPort()), (Credentials)new UsernamePasswordCredentials(user, pass));
            HttpGet httpget = new HttpGet(url.toExternalForm());
            System.out.println("executing request" + httpget.getRequestLine());
            HttpResponse response = httpclient.execute((HttpUriRequest)httpget);
            HttpEntity entity = response.getEntity();
            System.out.println("----------------------------------------");
            StatusLine statusLine = response.getStatusLine();
            System.out.println(statusLine);
            if (entity != null) {
                System.out.println("Response content length: " + entity.getContentLength());
            }
            Assert.assertEquals((long)200L, (long)statusLine.getStatusCode());
            EntityUtils.consume((HttpEntity)entity);
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
    }
}

