/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.test.config;

import java.io.InputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.picketlink.idm.credential.Credential;
import org.picketlink.idm.credential.PasswordCredential;
import org.picketlink.idm.credential.X509CertificateCredential;
import org.picketlink.idm.file.internal.FileBasedIdentityStore;
import org.picketlink.idm.file.internal.FileUser;
import org.picketlink.idm.internal.DefaultIdentityManager;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.spi.IdentityStore;

public class IdentityManagerInitializer {
    public static void initializeIdentityStore() {
        FileBasedIdentityStore theStore = new FileBasedIdentityStore();
        DefaultIdentityManager identityManager = new DefaultIdentityManager((IdentityStore)theStore);
        FileUser jbidTestUser = new FileUser("jbid test");
        identityManager.createUser((User)jbidTestUser);
        FileUser certUser = new FileUser("CN=jbid test, OU=JBoss, O=JBoss, C=US");
        identityManager.createUser((User)certUser);
        InputStream bis = Thread.currentThread().getContextClassLoader().getResourceAsStream("cert/servercert.txt");
        CertificateFactory cf = null;
        try {
            cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(bis);
            identityManager.updateCredential((User)jbidTestUser, (Credential)new X509CertificateCredential(cert));
            identityManager.updateCredential((User)certUser, (Credential)new X509CertificateCredential(cert));
            bis.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Error updating user certificate.", e);
        }
        FileUser adminUser = new FileUser("Aladdin");
        identityManager.createUser((User)adminUser);
        adminUser.setEmail("Aladdin@picketbox.com");
        adminUser.setFirstName("The");
        adminUser.setLastName("Aladdin");
        identityManager.updateCredential((User)adminUser, (Credential)new PasswordCredential("Open Sesame"));
        Role roleManager = identityManager.createRole("manager");
        Role roleConfidencial = identityManager.createRole("confidencial");
        Group groupCoreDeveloper = identityManager.createGroup("PicketBox Group");
        identityManager.grantRole(roleManager, (IdentityType)adminUser, groupCoreDeveloper);
        identityManager.grantRole(roleConfidencial, (IdentityType)adminUser, groupCoreDeveloper);
    }
}

