/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.test.authentication.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.picketbox.core.authentication.AuthenticationManager;
import org.picketbox.core.authentication.manager.PropertiesFileBasedAuthenticationManager;
import org.picketbox.core.util.Base64;
import org.picketbox.http.PicketBoxHTTPManager;
import org.picketbox.http.authentication.HTTPBasicAuthentication;
import org.picketbox.http.config.PicketBoxHTTPConfiguration;
import org.picketbox.test.authentication.http.AbstractAuthenticationTest;
import org.picketbox.test.http.TestServletRequest;
import org.picketbox.test.http.TestServletResponse;

public class HTTPBasicAuthenticationTestCase
extends AbstractAuthenticationTest {
    private HTTPBasicAuthentication httpBasic = null;

    @Before
    public void setup() throws Exception {
        super.initialize();
        this.httpBasic = new HTTPBasicAuthentication();
        this.configuration.authentication().authManager((AuthenticationManager)new PropertiesFileBasedAuthenticationManager());
        PicketBoxHTTPManager picketBoxManager = new PicketBoxHTTPManager((PicketBoxHTTPConfiguration)this.configuration.build());
        picketBoxManager.start();
        this.httpBasic.setPicketBoxManager(picketBoxManager);
    }

    @Test
    public void testHttpBasic() throws Exception {
        TestServletRequest req = new TestServletRequest(new InputStream(){

            public int read() throws IOException {
                return 0;
            }
        });
        TestServletResponse resp = new TestServletResponse(new OutputStream(){

            public void write(int b) throws IOException {
                System.out.println(b);
            }
        });
        req.addHeader("Authorization", "Basic " + this.getPositive());
        req.setContextPath("/test");
        req.setRequestURI(req.getContextPath() + "/index.html");
        Principal principal = this.httpBasic.authenticate((ServletRequest)req, (ServletResponse)resp);
        junit.framework.Assert.assertNotNull((Object)principal);
        req.clearHeaders();
        req.getSession().setAttribute("SUBJECT", null);
        req.addHeader("Authorization", "Basic " + this.getNegative());
        principal = this.httpBasic.authenticate((ServletRequest)req, (ServletResponse)resp);
        junit.framework.Assert.assertNull((Object)principal);
        String basicHeader = resp.getHeader("WWW-Authenticate");
        Assert.assertTrue((boolean)basicHeader.startsWith("basic realm="));
    }

    private String getPositive() {
        String str = "Aladdin:Open Sesame";
        String encoded = Base64.encodeBytes((byte[])str.getBytes());
        return encoded;
    }

    private String getNegative() {
        String str = "Aladdin:Bad sesame";
        String encoded = Base64.encodeBytes((byte[])str.getBytes());
        return encoded;
    }
}

