/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.test.authentication.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.picketbox.core.authentication.AuthenticationManager;
import org.picketbox.core.authentication.DigestHolder;
import org.picketbox.core.authentication.manager.PropertiesFileBasedAuthenticationManager;
import org.picketbox.core.exceptions.FormatException;
import org.picketbox.core.util.Base64;
import org.picketbox.core.util.HTTPDigestUtil;
import org.picketbox.http.PicketBoxHTTPManager;
import org.picketbox.http.authentication.HTTPDigestAuthentication;
import org.picketbox.http.config.PicketBoxHTTPConfiguration;
import org.picketbox.test.authentication.http.AbstractAuthenticationTest;
import org.picketbox.test.http.TestServletRequest;
import org.picketbox.test.http.TestServletResponse;

public class HTTPDigestAuthenticationTestCase
extends AbstractAuthenticationTest {
    private HTTPDigestAuthentication httpDigest = null;

    @Before
    public void setup() throws Exception {
        super.initialize();
        this.httpDigest = new HTTPDigestAuthentication();
        this.httpDigest.setRealmName("testrealm@host.com");
        this.httpDigest.setOpaque("5ccc069c403ebaf9f0171e9517f40e41");
        this.configuration.authentication().authManager((AuthenticationManager)new PropertiesFileBasedAuthenticationManager());
        PicketBoxHTTPManager picketBoxManager = new PicketBoxHTTPManager((PicketBoxHTTPConfiguration)this.configuration.build());
        picketBoxManager.start();
        this.httpDigest.setPicketBoxManager(picketBoxManager);
    }

    @Test
    public void testHttpDigest() throws Exception {
        TestServletRequest req = new TestServletRequest(new InputStream(){

            public int read() throws IOException {
                return 0;
            }
        });
        TestServletResponse resp = new TestServletResponse(new OutputStream(){

            public void write(int b) throws IOException {
                System.out.println(b);
            }
        });
        req.setMethod("GET");
        req.setContextPath("/test");
        req.setRequestURI(req.getContextPath() + "/index.html");
        Principal result = this.httpDigest.authenticate((ServletRequest)req, (ServletResponse)resp);
        junit.framework.Assert.assertNull((Object)result);
        String authorizationHeader = resp.getHeader("WWW-Authenticate");
        authorizationHeader = authorizationHeader.substring(7);
        String[] tokens = HTTPDigestUtil.quoteTokenize((String)authorizationHeader);
        DigestHolder digest = HTTPDigestUtil.digest((String[])tokens);
        req.addHeader("Authorization", "Digest " + this.getPositive(digest));
        result = this.httpDigest.authenticate((ServletRequest)req, (ServletResponse)resp);
        junit.framework.Assert.assertNotNull((Object)result);
        req.clearHeaders();
        req.getSession().setAttribute("SUBJECT", null);
        req.addHeader("Authorization", "Digest " + this.getNegative());
        result = this.httpDigest.authenticate((ServletRequest)req, (ServletResponse)resp);
        junit.framework.Assert.assertNull((Object)result);
        String digestHeader = resp.getHeader("WWW-Authenticate");
        Assert.assertTrue((boolean)digestHeader.startsWith("Digest realm="));
    }

    private String getPositive(DigestHolder digest) {
        String cnonce = "0a4f113b";
        String clientResponse = null;
        try {
            digest.setUsername("Mufasa");
            digest.setRequestMethod("GET");
            digest.setUri("/dir/index.html");
            digest.setCnonce(cnonce);
            digest.setNc("00000001");
            digest.setQop("auth");
            clientResponse = HTTPDigestUtil.clientResponseValue((DigestHolder)digest, (char[])"Circle Of Life".toCharArray());
        }
        catch (FormatException e) {
            throw new RuntimeException(e);
        }
        StringBuilder str = new StringBuilder(" username=\"Mufasa\",");
        str.append("realm=\"" + digest.getRealm() + "\",");
        str.append("nonce=\"").append(digest.getNonce()).append("\",");
        str.append("uri=\"/dir/index.html\",");
        str.append("qop=auth,").append("nc=00000001,").append("cnonce=\"" + cnonce + "\",");
        str.append("response=\"" + clientResponse + "\",");
        str.append("opaque=\"").append(digest.getOpaque()).append("\"");
        return str.toString();
    }

    private String getNegative() {
        String str = "Aladdin:Bad sesame";
        String encoded = Base64.encodeBytes((byte[])str.getBytes());
        return encoded;
    }
}

