/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.test.authentication.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.picketbox.core.authentication.AuthenticationManager;
import org.picketbox.core.authentication.manager.PropertiesFileBasedAuthenticationManager;
import org.picketbox.http.PicketBoxHTTPManager;
import org.picketbox.http.authentication.HTTPFormAuthentication;
import org.picketbox.http.config.PicketBoxHTTPConfiguration;
import org.picketbox.test.authentication.http.AbstractAuthenticationTest;
import org.picketbox.test.http.TestServletContext;
import org.picketbox.test.http.TestServletRequest;
import org.picketbox.test.http.TestServletResponse;

public class HTTPFormAuthenticationTestCase
extends AbstractAuthenticationTest {
    private HTTPFormAuthentication httpForm = null;
    private TestServletContext sc = new TestServletContext(new HashMap<String, String>());

    @Before
    public void setup() throws Exception {
        super.initialize();
        this.httpForm = new HTTPFormAuthentication();
        this.configuration.authentication().authManager((AuthenticationManager)new PropertiesFileBasedAuthenticationManager());
        PicketBoxHTTPManager picketBoxManager = new PicketBoxHTTPManager((PicketBoxHTTPConfiguration)this.configuration.build());
        picketBoxManager.start();
        this.httpForm.setPicketBoxManager(picketBoxManager);
    }

    @Test
    public void testHttpForm() throws Exception {
        TestServletRequest req = new TestServletRequest(this.sc, new InputStream(){

            public int read() throws IOException {
                return 0;
            }
        });
        TestServletResponse resp = new TestServletResponse(new OutputStream(){

            public void write(int b) throws IOException {
                System.out.println(b);
            }
        });
        req.setMethod("GET");
        String orig = "http://msite/someurl";
        req.setContextPath("/");
        req.setRequestURI(orig);
        Principal result = this.httpForm.authenticate((ServletRequest)req, (ServletResponse)resp);
        junit.framework.Assert.assertNull((Object)result);
        TestServletContext.TestRequestDispatcher rd = this.sc.getLast();
        Assert.assertEquals((Object)rd.getRequest(), (Object)req);
        Assert.assertEquals((Object)"/login.jsp", (Object)rd.getRequestUri());
        TestServletRequest newReq = new TestServletRequest(new InputStream(){

            public int read() throws IOException {
                return 0;
            }
        });
        newReq.setRequestURI("http://msite/j_security_check");
        newReq.setContextPath("/msite");
        newReq.setParameter("j_username", "Aladdin");
        newReq.setParameter("j_password", "Open Sesame");
        result = this.httpForm.authenticate((ServletRequest)newReq, (ServletResponse)resp);
        junit.framework.Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)resp.getSendRedirectedURI(), (Object)orig);
    }
}

