/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.test.authentication.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.picketbox.core.authentication.AbstractAuthenticationManager;
import org.picketbox.core.authentication.AuthenticationManager;
import org.picketbox.core.exceptions.AuthenticationException;
import org.picketbox.http.PicketBoxHTTPManager;
import org.picketbox.http.authentication.HTTPClientCertAuthentication;
import org.picketbox.http.config.PicketBoxHTTPConfiguration;
import org.picketbox.test.authentication.http.AbstractAuthenticationTest;
import org.picketbox.test.http.TestServletRequest;
import org.picketbox.test.http.TestServletResponse;

public class HTTPClientCertAuthenticationTestCase
extends AbstractAuthenticationTest {
    private HTTPClientCertAuthentication httpClientCert = null;

    @Before
    public void setup() throws Exception {
        super.initialize();
        this.httpClientCert = new HTTPClientCertAuthentication();
        this.configuration.authentication().authManager((AuthenticationManager)new HTTPClientCertAuthenticationTestCaseAM());
        PicketBoxHTTPManager picketBoxManager = new PicketBoxHTTPManager((PicketBoxHTTPConfiguration)this.configuration.build());
        picketBoxManager.start();
        this.httpClientCert.setPicketBoxManager(picketBoxManager);
    }

    @Test
    public void testHttpForm() throws Exception {
        TestServletRequest req = new TestServletRequest(new InputStream(){

            public int read() throws IOException {
                return 0;
            }
        });
        TestServletResponse resp = new TestServletResponse(new OutputStream(){

            public void write(int b) throws IOException {
                System.out.println(b);
            }
        });
        req.setContextPath("/test");
        req.setRequestURI(req.getContextPath() + "/index.html");
        InputStream bis = this.getClass().getClassLoader().getResourceAsStream("cert/servercert.txt");
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)cf.generateCertificate(bis);
        bis.close();
        Assert.assertNotNull((Object)cert);
        Principal result = this.httpClientCert.authenticate((ServletRequest)req, (ServletResponse)resp);
        Assert.assertNull((Object)result);
        req.setAttribute("javax.servlet.request.X509Certificate", new X509Certificate[]{cert});
        result = this.httpClientCert.authenticate((ServletRequest)req, (ServletResponse)resp);
        Assert.assertNotNull((Object)result);
    }

    private class HTTPClientCertAuthenticationTestCaseAM
    extends AbstractAuthenticationManager {
        private HTTPClientCertAuthenticationTestCaseAM() {
        }

        public Principal authenticate(final String username, Object credential) throws AuthenticationException {
            if ("CN=jbid test, OU=JBoss, O=JBoss, C=US".equalsIgnoreCase(username) && ((String)credential).startsWith("W2G")) {
                return new Principal(){

                    public String getName() {
                        return username;
                    }
                };
            }
            return null;
        }

        public boolean started() {
            return false;
        }

        public void start() {
        }

        public boolean stopped() {
            return false;
        }

        public void stop() {
        }
    }
}

