/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.test.authentication.http;

import org.junit.Assert;
import org.junit.Test;
import org.picketbox.core.util.HTTPDigestUtil;

public class HTTPDigestUtilTestCase {
    String val = "Digest username=\"Mufasa\",realm=\"testrealm@host.com\",nonce=\"dcd98b7102dd2f0e8b11d0f600bfb0c093\",uri=\"/dir/index.html\",qop=auth,nc=00000001,cnonce=\"0a4f113b\",response=\"6629fae49393a05397450978507c4ef1\",opaque=\"5ccc069c403ebaf9f0171e9517f40e41\"";

    @Test
    public void testQuoteTokenize() throws Exception {
        String[] tokens = HTTPDigestUtil.quoteTokenize((String)this.val);
        this.validateTokens(tokens);
    }

    @Test
    public void testExtract() throws Exception {
        String[] tokens = HTTPDigestUtil.quoteTokenize((String)this.val);
        Assert.assertTrue((tokens.length > 0 ? 1 : 0) != 0);
        this.validateExtractedTokens(tokens);
    }

    private void validateTokens(String[] tokens) {
        Assert.assertTrue((tokens.length > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"Digest username=\"Mufasa\"", (Object)tokens[0]);
        Assert.assertEquals((Object)"realm=\"testrealm@host.com\"", (Object)tokens[1]);
        Assert.assertEquals((Object)"nonce=\"dcd98b7102dd2f0e8b11d0f600bfb0c093\"", (Object)tokens[2]);
        Assert.assertEquals((Object)"uri=\"/dir/index.html\"", (Object)tokens[3]);
        Assert.assertEquals((Object)"qop=auth", (Object)tokens[4]);
        Assert.assertEquals((Object)"nc=00000001", (Object)tokens[5]);
        Assert.assertEquals((Object)"cnonce=\"0a4f113b\"", (Object)tokens[6]);
        Assert.assertEquals((Object)"response=\"6629fae49393a05397450978507c4ef1\"", (Object)tokens[7]);
        Assert.assertEquals((Object)"opaque=\"5ccc069c403ebaf9f0171e9517f40e41\"", (Object)tokens[8]);
    }

    private void validateExtractedTokens(String[] tokens) {
        Assert.assertEquals((Object)"Mufasa", (Object)HTTPDigestUtil.userName((String)tokens[0]));
        Assert.assertEquals((Object)"testrealm@host.com", (Object)HTTPDigestUtil.extract((String)tokens[1], (String)"realm="));
        Assert.assertEquals((Object)"dcd98b7102dd2f0e8b11d0f600bfb0c093", (Object)HTTPDigestUtil.extract((String)tokens[2], (String)"nonce="));
        Assert.assertEquals((Object)"/dir/index.html", (Object)HTTPDigestUtil.extract((String)tokens[3], (String)"uri="));
        Assert.assertEquals((Object)"auth", (Object)HTTPDigestUtil.extract((String)tokens[4], (String)"qop="));
        Assert.assertEquals((Object)"00000001", (Object)HTTPDigestUtil.extract((String)tokens[5], (String)"nc="));
        Assert.assertEquals((Object)"0a4f113b", (Object)HTTPDigestUtil.extract((String)tokens[6], (String)"cnonce="));
        Assert.assertEquals((Object)"6629fae49393a05397450978507c4ef1", (Object)HTTPDigestUtil.extract((String)tokens[7], (String)"response="));
        Assert.assertEquals((Object)"5ccc069c403ebaf9f0171e9517f40e41", (Object)HTTPDigestUtil.extract((String)tokens[8], (String)"opaque="));
    }
}

