/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.test.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.picketbox.core.Credential;
import org.picketbox.core.PicketBoxSubject;
import org.picketbox.core.authentication.credential.UsernamePasswordCredential;
import org.picketbox.core.authorization.Resource;
import org.picketbox.core.identity.IdentityManager;
import org.picketbox.http.PicketBoxHTTPManager;
import org.picketbox.http.PicketBoxHTTPSubject;
import org.picketbox.http.authorization.resource.WebResource;
import org.picketbox.http.config.HTTPConfigurationBuilder;
import org.picketbox.http.config.PicketBoxHTTPConfiguration;
import org.picketbox.http.resource.ProtectedResourceConstraint;
import org.picketbox.test.http.TestServletRequest;
import org.picketbox.test.http.TestServletResponse;

public class PicketBoxHTTPConfigurationTestCase {
    private PicketBoxHTTPManager picketBoxManager;

    @Before
    public void onSetup() {
        HTTPConfigurationBuilder builder = new HTTPConfigurationBuilder();
        builder.identityManager().manager(new IdentityManager(){

            public PicketBoxSubject getIdentity(PicketBoxSubject resultingSubject) {
                ArrayList<String> roles = new ArrayList<String>();
                roles.add("Manager");
                roles.add("Financial");
                resultingSubject.setRoleNames(roles);
                return resultingSubject;
            }
        });
        builder.protectedResource().resource("/secure/*", ProtectedResourceConstraint.ALL).resource("/notSecured/index.html", ProtectedResourceConstraint.NOT_PROTECTED).resource("/onlyRoleManager/index.html", new String[]{"Manager"}).resource("/onlyRoleFinancial/index.html", new String[]{"Financial"});
        PicketBoxHTTPConfiguration build = (PicketBoxHTTPConfiguration)builder.build();
        this.picketBoxManager = new PicketBoxHTTPManager(build);
        this.picketBoxManager.start();
    }

    @Test
    public void testFluentConfiguration() throws Exception {
        TestServletRequest req = new TestServletRequest(new InputStream(){

            public int read() throws IOException {
                return 0;
            }
        });
        TestServletResponse resp = new TestServletResponse(new OutputStream(){

            public void write(int b) throws IOException {
                System.out.println(b);
            }
        });
        req.setMethod("GET");
        req.setContextPath("/test-app");
        req.setRequestURI(req.getContextPath() + "/secure/index.html");
        PicketBoxHTTPSubject authenticationSubject = new PicketBoxHTTPSubject((HttpServletRequest)req, (HttpServletResponse)resp, (Credential)new UsernamePasswordCredential("admin", "admin"));
        PicketBoxSubject subject = this.picketBoxManager.authenticate((PicketBoxSubject)authenticationSubject);
        Assert.assertNotNull((Object)subject);
    }

    @Test
    public void testNotProtectedResource() throws Exception {
        TestServletRequest req = new TestServletRequest(new InputStream(){

            public int read() throws IOException {
                return 0;
            }
        });
        TestServletResponse resp = new TestServletResponse(new OutputStream(){

            public void write(int b) throws IOException {
                System.out.println(b);
            }
        });
        req.setMethod("GET");
        req.setContextPath("/test-app");
        req.setRequestURI(req.getContextPath() + "/notSecured/index.html");
        PicketBoxHTTPSubject authenticationSubject = new PicketBoxHTTPSubject((HttpServletRequest)req, (HttpServletResponse)resp, (Credential)new UsernamePasswordCredential("admin", "admin"));
        PicketBoxSubject subject = this.picketBoxManager.authenticate((PicketBoxSubject)authenticationSubject);
        Assert.assertNotNull((Object)subject);
        Assert.assertFalse((boolean)subject.isAuthenticated());
    }

    @Test
    public void testRoleProtectedResource() throws Exception {
        TestServletRequest req = new TestServletRequest(new InputStream(){

            public int read() throws IOException {
                return 0;
            }
        });
        TestServletResponse resp = new TestServletResponse(new OutputStream(){

            public void write(int b) throws IOException {
                System.out.println(b);
            }
        });
        req.setMethod("GET");
        req.setContextPath("/test-app");
        req.setRequestURI(req.getContextPath() + "/onlyRoleManager/index.html");
        PicketBoxHTTPSubject authenticationSubject = new PicketBoxHTTPSubject((HttpServletRequest)req, (HttpServletResponse)resp, (Credential)new UsernamePasswordCredential("admin", "admin"));
        PicketBoxSubject subject = this.picketBoxManager.authenticate((PicketBoxSubject)authenticationSubject);
        Assert.assertNotNull((Object)subject);
        WebResource resource = new WebResource();
        resource.setRequest((HttpServletRequest)req);
        resource.setResponse((HttpServletResponse)resp);
        boolean isAuthorized = this.picketBoxManager.authorize(subject, (Resource)resource);
        Assert.assertTrue((boolean)isAuthorized);
    }
}

