/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.http.test.authentication;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.picketbox.core.UserContext;
import org.picketbox.core.UserCredential;
import org.picketbox.core.authentication.AuthenticationStatus;
import org.picketbox.core.util.Base64;
import org.picketbox.http.HTTPUserContext;
import org.picketbox.http.authentication.credential.HTTPBasicCredential;
import org.picketbox.http.config.HTTPConfigurationBuilder;
import org.picketbox.http.test.TestServletRequest;
import org.picketbox.http.test.TestServletResponse;
import org.picketbox.http.test.authentication.AbstractAuthenticationTest;

public class HTTPBasicAuthenticationTestCase
extends AbstractAuthenticationTest {
    @Before
    public void setup() throws Exception {
        super.initialize();
    }

    @Override
    protected void doConfigureManager(HTTPConfigurationBuilder configuration) {
        configuration.authentication().digest().realm("Custom Realm");
    }

    @Test
    public void testHttpBasic() throws Exception {
        TestServletRequest req = new TestServletRequest(new InputStream(){

            @Override
            public int read() throws IOException {
                return 0;
            }
        });
        TestServletResponse resp = new TestServletResponse(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                System.out.println(b);
            }
        });
        req.addHeader("Authorization", "Basic " + this.getPositive());
        req.setContextPath("/test");
        req.setRequestURI(req.getContextPath() + "/index.html");
        UserContext authenticatedUser = this.picketBoxManager.authenticate((UserContext)new HTTPUserContext((HttpServletRequest)req, (HttpServletResponse)resp, (UserCredential)new HTTPBasicCredential((HttpServletRequest)req, (HttpServletResponse)resp)));
        junit.framework.Assert.assertNotNull((Object)authenticatedUser);
        Assert.assertTrue((boolean)authenticatedUser.isAuthenticated());
        Assert.assertNotNull((Object)authenticatedUser.getAuthenticationResult().getStatus());
        Assert.assertEquals((Object)authenticatedUser.getAuthenticationResult().getStatus(), (Object)AuthenticationStatus.SUCCESS);
        req.clearHeaders();
        req.getSession().setAttribute("SUBJECT", null);
        req.addHeader("Authorization", "Basic " + this.getNegative());
        authenticatedUser = this.picketBoxManager.authenticate((UserContext)new HTTPUserContext((HttpServletRequest)req, (HttpServletResponse)resp, (UserCredential)new HTTPBasicCredential((HttpServletRequest)req, (HttpServletResponse)resp)));
        junit.framework.Assert.assertNotNull((Object)authenticatedUser);
        Assert.assertFalse((boolean)authenticatedUser.isAuthenticated());
        Assert.assertNotNull((Object)authenticatedUser.getAuthenticationResult().getStatus());
        Assert.assertEquals((Object)authenticatedUser.getAuthenticationResult().getStatus(), (Object)AuthenticationStatus.INVALID_CREDENTIALS);
        String basicHeader = resp.getHeader("WWW-Authenticate");
        Assert.assertTrue((boolean)basicHeader.startsWith("basic realm="));
    }

    private String getPositive() {
        String str = "Aladdin:Open Sesame";
        String encoded = Base64.encodeBytes((byte[])str.getBytes());
        return encoded;
    }

    private String getNegative() {
        String str = "Aladdin:Bad sesame";
        String encoded = Base64.encodeBytes((byte[])str.getBytes());
        return encoded;
    }
}

