/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.http.test.jetty;

import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.bio.SocketConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.webapp.WebAppContext;
import org.junit.After;
import org.junit.Before;

public abstract class EmbeddedWebServerBase {
    protected Server server = null;

    @Before
    public void setUp() throws Exception {
        this.server = new Server();
        this.server.setConnectors(this.getConnectors());
        this.establishUserApps();
        this.server.start();
    }

    @After
    public void tearDown() throws Exception {
        if (this.server != null) {
            this.server.stop();
            this.server.destroy();
            this.server = null;
        }
    }

    protected Connector[] getConnectors() {
        SocketConnector connector = new SocketConnector();
        connector.setPort(11080);
        return new Connector[]{connector};
    }

    protected abstract void establishUserApps();

    protected FilterMapping createFilterMapping(String pathSpec, FilterHolder filterHolder) {
        FilterMapping filterMapping = new FilterMapping();
        filterMapping.setPathSpec(pathSpec);
        filterMapping.setFilterName(filterHolder.getName());
        return filterMapping;
    }

    protected WebAppContext createWebApp(String contextPath, String warURLString) {
        WebAppContext webapp = new WebAppContext();
        webapp.setContextPath(contextPath);
        webapp.setWar(warURLString);
        Thread.currentThread().setContextClassLoader(webapp.getClassLoader());
        return webapp;
    }
}

