/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.test.authentication.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.picketbox.core.UserContext;
import org.picketbox.core.UserCredential;
import org.picketbox.core.authentication.AuthenticationStatus;
import org.picketbox.core.util.Base64;
import org.picketbox.http.HTTPUserContext;
import org.picketbox.http.authentication.HTTPDigestCredential;
import org.picketbox.http.config.HTTPConfigurationBuilder;
import org.picketbox.http.util.HTTPDigestUtil;
import org.picketbox.test.authentication.http.AbstractAuthenticationTest;
import org.picketbox.test.http.TestServletRequest;
import org.picketbox.test.http.TestServletResponse;
import org.picketlink.idm.credential.Digest;

public class HTTPDigestAuthenticationTestCase
extends AbstractAuthenticationTest {
    @Before
    public void setup() throws Exception {
        super.initialize();
    }

    @Override
    protected void doConfigureManager(HTTPConfigurationBuilder configuration) {
        configuration.authentication().digest().realm("testrealm@host.com");
        configuration.authentication().digest().opaque("5ccc069c403ebaf9f0171e9517f40e41");
    }

    @Test
    public void testHttpDigest() throws Exception {
        TestServletRequest req = new TestServletRequest(new InputStream(){

            @Override
            public int read() throws IOException {
                return 0;
            }
        });
        TestServletResponse resp = new TestServletResponse(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                System.out.println(b);
            }
        });
        req.setMethod("GET");
        req.setContextPath("/test");
        req.setRequestURI(req.getContextPath() + "/index.html");
        UserContext authenticatedUser = this.picketBoxManager.authenticate((UserContext)new HTTPUserContext((HttpServletRequest)req, (HttpServletResponse)resp, (UserCredential)new HTTPDigestCredential((HttpServletRequest)req, (HttpServletResponse)resp)));
        junit.framework.Assert.assertNotNull((Object)authenticatedUser);
        Assert.assertFalse((boolean)authenticatedUser.isAuthenticated());
        Assert.assertNotNull((Object)authenticatedUser.getAuthenticationResult().getStatus());
        Assert.assertEquals((Object)authenticatedUser.getAuthenticationResult().getStatus(), (Object)AuthenticationStatus.CONTINUE);
        String authorizationHeader = resp.getHeader("WWW-Authenticate");
        authorizationHeader = authorizationHeader.substring(7);
        String[] tokens = HTTPDigestUtil.quoteTokenize((String)authorizationHeader);
        Digest digest = HTTPDigestUtil.digest((String[])tokens);
        req.addHeader("Authorization", "Digest " + this.getPositive(digest));
        authenticatedUser = this.picketBoxManager.authenticate((UserContext)new HTTPUserContext((HttpServletRequest)req, (HttpServletResponse)resp, (UserCredential)new HTTPDigestCredential((HttpServletRequest)req, (HttpServletResponse)resp)));
        junit.framework.Assert.assertNotNull((Object)authenticatedUser);
        Assert.assertTrue((boolean)authenticatedUser.isAuthenticated());
        Assert.assertNotNull((Object)authenticatedUser.getAuthenticationResult().getStatus());
        Assert.assertEquals((Object)authenticatedUser.getAuthenticationResult().getStatus(), (Object)AuthenticationStatus.SUCCESS);
        req.clearHeaders();
        req.getSession().setAttribute("SUBJECT", null);
        req.addHeader("Authorization", "Digest " + this.getNegative());
        authenticatedUser = this.picketBoxManager.authenticate((UserContext)new HTTPUserContext((HttpServletRequest)req, (HttpServletResponse)resp, (UserCredential)new HTTPDigestCredential((HttpServletRequest)req, (HttpServletResponse)resp)));
        junit.framework.Assert.assertNotNull((Object)authenticatedUser);
        Assert.assertFalse((boolean)authenticatedUser.isAuthenticated());
        Assert.assertNotNull((Object)authenticatedUser.getAuthenticationResult().getStatus());
        Assert.assertEquals((Object)authenticatedUser.getAuthenticationResult().getStatus(), (Object)AuthenticationStatus.INVALID_CREDENTIALS);
        String digestHeader = resp.getHeader("WWW-Authenticate");
        Assert.assertTrue((boolean)digestHeader.startsWith("Digest realm="));
    }

    private String getPositive(Digest digest) {
        String cnonce = "0a4f113b";
        String clientResponse = null;
        digest.setUsername("Aladdin");
        digest.setMethod("GET");
        digest.setUri("/dir/index.html");
        digest.setCnonce(cnonce);
        digest.setNc("00000001");
        digest.setQop("auth");
        clientResponse = HTTPDigestUtil.clientResponseValue((Digest)digest, (char[])"Open Sesame".toCharArray());
        StringBuilder str = new StringBuilder(" username=\"Aladdin\",");
        str.append("realm=\"" + digest.getRealm() + "\",");
        str.append("nonce=\"").append(digest.getNonce()).append("\",");
        str.append("uri=\"/dir/index.html\",");
        str.append("qop=auth,").append("nc=00000001,").append("cnonce=\"" + cnonce + "\",");
        str.append("response=\"" + clientResponse + "\",");
        str.append("opaque=\"").append(digest.getOpaque()).append("\"");
        return str.toString();
    }

    private String getNegative() {
        String str = "Aladdin:Bad sesame";
        String encoded = Base64.encodeBytes((byte[])str.getBytes());
        return encoded;
    }
}

