/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.test.config;

import java.io.InputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.config.IdentityConfiguration;
import org.picketlink.idm.config.StoreConfiguration;
import org.picketlink.idm.credential.PlainTextPassword;
import org.picketlink.idm.credential.X509Cert;
import org.picketlink.idm.file.internal.FileIdentityStoreConfiguration;
import org.picketlink.idm.internal.DefaultIdentityManager;
import org.picketlink.idm.internal.DefaultIdentityStoreInvocationContextFactory;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleGroup;
import org.picketlink.idm.model.SimpleRole;
import org.picketlink.idm.model.SimpleUser;
import org.picketlink.idm.spi.IdentityStoreInvocationContextFactory;

public class IdentityManagerInitializer {
    public static IdentityManager createIdentityManager() {
        IdentityConfiguration config = new IdentityConfiguration();
        FileIdentityStoreConfiguration fileConfig = new FileIdentityStoreConfiguration();
        fileConfig.setAlwaysCreateFiles(false);
        config.addStoreConfiguration((StoreConfiguration)fileConfig);
        DefaultIdentityManager identityManager = new DefaultIdentityManager();
        identityManager.bootstrap(config, (IdentityStoreInvocationContextFactory)new DefaultIdentityStoreInvocationContextFactory());
        return identityManager;
    }

    public static void initializeIdentityStore(IdentityManager identityManager, boolean encodePassword) {
        SimpleUser jbidTestUser = new SimpleUser("jbid test");
        identityManager.add((IdentityType)jbidTestUser);
        SimpleUser certUser = new SimpleUser("CN=jbid test, OU=JBoss, O=JBoss, C=US");
        identityManager.add((IdentityType)certUser);
        InputStream bis = IdentityManagerInitializer.class.getClassLoader().getResourceAsStream("cert/servercert.txt");
        CertificateFactory cf = null;
        try {
            cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(bis);
            identityManager.updateCredential((Agent)jbidTestUser, (Object)new X509Cert(cert));
            identityManager.updateCredential((Agent)certUser, (Object)new X509Cert(cert));
            bis.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Error updating user certificate.", e);
        }
        SimpleUser adminUser = new SimpleUser("Aladdin");
        identityManager.add((IdentityType)adminUser);
        adminUser.setEmail("Aladdin@picketbox.com");
        adminUser.setFirstName("The");
        adminUser.setLastName("Aladdin");
        PlainTextPassword password = new PlainTextPassword("Open Sesame".toCharArray());
        password.setEncodePassword(encodePassword);
        identityManager.updateCredential((Agent)adminUser, (Object)password);
        SimpleRole roleManager = new SimpleRole("manager");
        identityManager.add((IdentityType)roleManager);
        SimpleRole roleConfidencial = new SimpleRole("confidencial");
        identityManager.add((IdentityType)roleConfidencial);
        SimpleGroup groupCoreDeveloper = new SimpleGroup("PicketBox Group");
        identityManager.add((IdentityType)groupCoreDeveloper);
        identityManager.grantRole((IdentityType)adminUser, (Role)roleManager);
        identityManager.grantRole((IdentityType)adminUser, (Role)roleConfidencial);
        identityManager.addToGroup((IdentityType)adminUser, (Group)groupCoreDeveloper);
    }
}

