/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.test.authentication.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.picketbox.core.UserContext;
import org.picketbox.core.UserCredential;
import org.picketbox.core.authentication.AuthenticationStatus;
import org.picketbox.http.HTTPUserContext;
import org.picketbox.http.authentication.credential.HTTPClientCertCredential;
import org.picketbox.http.config.HTTPConfigurationBuilder;
import org.picketbox.test.authentication.http.AbstractAuthenticationTest;
import org.picketbox.test.http.TestServletRequest;
import org.picketbox.test.http.TestServletResponse;

public class HTTPClientCertAuthenticationTestCase
extends AbstractAuthenticationTest {
    @Before
    public void onSetup() throws Exception {
        super.initialize();
    }

    @Override
    protected void doConfigureManager(HTTPConfigurationBuilder configuration) {
        configuration.authentication().clientCert().useCNAsPrincipal();
    }

    @Test
    public void testAuthenticationUsingCNAsUserName() throws Exception {
        TestServletRequest req = new TestServletRequest(new InputStream(){

            @Override
            public int read() throws IOException {
                return 0;
            }
        });
        TestServletResponse resp = new TestServletResponse(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                System.out.println(b);
            }
        });
        req.setContextPath("/test");
        req.setRequestURI(req.getContextPath() + "/index.html");
        InputStream bis = this.getClass().getClassLoader().getResourceAsStream("cert/servercert.txt");
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)cf.generateCertificate(bis);
        bis.close();
        junit.framework.Assert.assertNotNull((Object)cert);
        UserContext authenticatedUser = this.picketBoxManager.authenticate((UserContext)new HTTPUserContext((HttpServletRequest)req, (HttpServletResponse)resp, (UserCredential)new HTTPClientCertCredential((HttpServletRequest)req, (HttpServletResponse)resp)));
        junit.framework.Assert.assertNotNull((Object)authenticatedUser);
        Assert.assertFalse((boolean)authenticatedUser.isAuthenticated());
        Assert.assertNotNull((Object)authenticatedUser.getAuthenticationResult().getStatus());
        Assert.assertEquals((Object)authenticatedUser.getAuthenticationResult().getStatus(), (Object)AuthenticationStatus.CONTINUE);
        req.setAttribute("javax.servlet.request.X509Certificate", new X509Certificate[]{cert});
        authenticatedUser = this.picketBoxManager.authenticate((UserContext)new HTTPUserContext((HttpServletRequest)req, (HttpServletResponse)resp, (UserCredential)new HTTPClientCertCredential((HttpServletRequest)req, (HttpServletResponse)resp)));
        junit.framework.Assert.assertNotNull((Object)authenticatedUser);
        Assert.assertTrue((boolean)authenticatedUser.isAuthenticated());
        Assert.assertNotNull((Object)authenticatedUser.getAuthenticationResult().getStatus());
        Assert.assertEquals((Object)authenticatedUser.getAuthenticationResult().getStatus(), (Object)AuthenticationStatus.SUCCESS);
    }
}

