/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.test.authentication.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.picketbox.core.UserContext;
import org.picketbox.core.UserCredential;
import org.picketbox.core.authentication.AuthenticationStatus;
import org.picketbox.http.HTTPUserContext;
import org.picketbox.http.authentication.credential.HTTPFormCredential;
import org.picketbox.test.authentication.http.AbstractAuthenticationTest;
import org.picketbox.test.http.TestServletContext;
import org.picketbox.test.http.TestServletRequest;
import org.picketbox.test.http.TestServletResponse;

public class HTTPDefaultFormAuthenticationTestCase
extends AbstractAuthenticationTest {
    private static final String CONTEXT_PATH = "/msite";
    private TestServletContext sc = new TestServletContext(new HashMap<String, String>());

    @Before
    public void setup() throws Exception {
        super.initialize();
    }

    @Test
    public void testDefaultConfiguration() throws Exception {
        TestServletRequest req = new TestServletRequest(this.sc, new InputStream(){

            @Override
            public int read() throws IOException {
                return 0;
            }
        });
        TestServletResponse resp = new TestServletResponse(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                System.out.println(b);
            }
        });
        req.setMethod("GET");
        String orig = "http://msite/someurl";
        req.setContextPath("/");
        req.setRequestURI(orig);
        UserContext authenticatedUser = this.picketBoxManager.authenticate((UserContext)new HTTPUserContext((HttpServletRequest)req, (HttpServletResponse)resp, (UserCredential)new HTTPFormCredential((HttpServletRequest)req, (HttpServletResponse)resp)));
        junit.framework.Assert.assertNotNull((Object)authenticatedUser);
        Assert.assertFalse((boolean)authenticatedUser.isAuthenticated());
        Assert.assertNotNull((Object)authenticatedUser.getAuthenticationResult().getStatus());
        Assert.assertEquals((Object)authenticatedUser.getAuthenticationResult().getStatus(), (Object)AuthenticationStatus.CONTINUE);
        TestServletContext.TestRequestDispatcher rd = this.sc.getLast();
        Assert.assertEquals((Object)rd.getRequest(), (Object)req);
        Assert.assertEquals((Object)"/login.jsp", (Object)rd.getRequestUri());
        TestServletRequest newReq = new TestServletRequest(new InputStream(){

            @Override
            public int read() throws IOException {
                return 0;
            }
        });
        newReq.setRequestURI("http://msite/j_security_check");
        newReq.setContextPath(CONTEXT_PATH);
        newReq.setParameter("j_username", "Aladdin");
        newReq.setParameter("j_password", "Open Sesame");
        authenticatedUser = this.picketBoxManager.authenticate((UserContext)new HTTPUserContext((HttpServletRequest)newReq, (HttpServletResponse)resp, (UserCredential)new HTTPFormCredential((HttpServletRequest)newReq, (HttpServletResponse)resp)));
        junit.framework.Assert.assertNotNull((Object)authenticatedUser);
        Assert.assertTrue((boolean)authenticatedUser.isAuthenticated());
        Assert.assertNotNull((Object)authenticatedUser.getAuthenticationResult().getStatus());
        Assert.assertEquals((Object)authenticatedUser.getAuthenticationResult().getStatus(), (Object)AuthenticationStatus.SUCCESS);
        Assert.assertEquals((Object)resp.getSendRedirectedURI(), (Object)orig);
    }
}

