/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.test.authentication.http.jetty;

import java.net.URL;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.auth.DigestScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.webapp.WebAppContext;
import org.junit.Assert;
import org.junit.Test;
import org.picketbox.http.filters.DelegatingSecurityFilter;
import org.picketbox.http.util.HTTPDigestUtil;
import org.picketbox.test.authentication.http.jetty.HTTPDigestConfigurationProvider;
import org.picketbox.test.http.jetty.EmbeddedWebServerBase;
import org.picketlink.idm.credential.internal.Digest;

public class DelegatingSecurityFilterHTTPDigestUnitTestCase
extends EmbeddedWebServerBase {
    String urlStr = "http://localhost:11080/auth/";

    @Override
    protected void establishUserApps() {
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        if (tcl == null) {
            tcl = this.getClass().getClassLoader();
        }
        String WEBAPPDIR = "auth/webapp";
        String CONTEXTPATH = "/auth";
        URL warUrl = tcl.getResource("auth/webapp");
        String warUrlString = warUrl.toExternalForm();
        WebAppContext webapp = this.createWebApp("/auth", warUrlString);
        this.server.setHandler((Handler)webapp);
        System.setProperty("picketbox.username", "Aladdin");
        System.setProperty("picketbox.credential", "Open Sesame");
        FilterHolder filterHolder = new FilterHolder(DelegatingSecurityFilter.class);
        webapp.setInitParameter("org.picketbox.authentication", "Digest");
        webapp.setInitParameter("org.picketbox.configuration.provider", HTTPDigestConfigurationProvider.class.getName());
        ServletHandler servletHandler = new ServletHandler();
        servletHandler.addFilter(filterHolder, this.createFilterMapping("/", filterHolder));
        webapp.setServletHandler(servletHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDigestAuth() throws Exception {
        URL url = new URL(this.urlStr);
        DefaultHttpClient httpclient = null;
        try {
            String user = "Aladdin";
            String pass = "Open Sesame";
            httpclient = new DefaultHttpClient();
            HttpGet httpget = new HttpGet(url.toExternalForm());
            HttpResponse response = httpclient.execute((HttpUriRequest)httpget);
            Assert.assertEquals((long)401L, (long)response.getStatusLine().getStatusCode());
            Header[] headers = response.getHeaders("WWW-Authenticate");
            HttpEntity entity = response.getEntity();
            EntityUtils.consume((HttpEntity)entity);
            Header header = headers[0];
            String value = header.getValue();
            value = value.substring(7).trim();
            String[] tokens = HTTPDigestUtil.quoteTokenize((String)value);
            Digest digestHolder = HTTPDigestUtil.digest((String[])tokens);
            DigestScheme digestAuth = new DigestScheme();
            digestAuth.overrideParamter("algorithm", "MD5");
            digestAuth.overrideParamter("realm", digestHolder.getRealm());
            digestAuth.overrideParamter("nonce", digestHolder.getNonce());
            digestAuth.overrideParamter("qop", "auth");
            digestAuth.overrideParamter("nc", "0001");
            digestAuth.overrideParamter("cnonce", DigestScheme.createCnonce());
            digestAuth.overrideParamter("opaque", digestHolder.getOpaque());
            httpget = new HttpGet(url.toExternalForm());
            Header auth = digestAuth.authenticate((Credentials)new UsernamePasswordCredentials(user, pass), (HttpRequest)httpget);
            System.out.println(auth.getName());
            System.out.println(auth.getValue());
            httpget.setHeader(auth);
            System.out.println("executing request" + httpget.getRequestLine());
            response = httpclient.execute((HttpUriRequest)httpget);
            entity = response.getEntity();
            System.out.println("----------------------------------------");
            StatusLine statusLine = response.getStatusLine();
            System.out.println(statusLine);
            if (entity != null) {
                System.out.println("Response content length: " + entity.getContentLength());
            }
            Assert.assertEquals((long)200L, (long)statusLine.getStatusCode());
            EntityUtils.consume((HttpEntity)entity);
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
    }
}

