/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.test.authentication.http.jetty;

import java.io.InputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.picketbox.core.InitializedEvent;
import org.picketbox.core.event.EventObserver;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.credential.internal.Digest;
import org.picketlink.idm.credential.internal.Password;
import org.picketlink.idm.credential.internal.X509Cert;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleGroup;
import org.picketlink.idm.model.SimpleRole;
import org.picketlink.idm.model.SimpleUser;

public class InitializationHandler {
    @EventObserver
    public void onInitialized(InitializedEvent event) {
        IdentityManager identityManager = event.getPicketBoxManager().getIdentityManager();
        SimpleUser jbidTestUser = new SimpleUser("jbid test");
        identityManager.add((IdentityType)jbidTestUser);
        SimpleUser certUser = new SimpleUser("CN=jbid test, OU=JBoss, O=JBoss, C=US");
        identityManager.add((IdentityType)certUser);
        InputStream bis = this.getClass().getClassLoader().getResourceAsStream("cert/servercert.txt");
        CertificateFactory cf = null;
        try {
            cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(bis);
            identityManager.updateCredential((Agent)jbidTestUser, (Object)new X509Cert(cert));
            identityManager.updateCredential((Agent)certUser, (Object)new X509Cert(cert));
            bis.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Error updating user certificate.", e);
        }
        SimpleUser adminUser = new SimpleUser("Aladdin");
        identityManager.add((IdentityType)adminUser);
        adminUser.setEmail("Aladdin@picketbox.com");
        adminUser.setFirstName("The");
        adminUser.setLastName("Aladdin");
        String plainTextPassword = "Open Sesame";
        Password password = new Password(plainTextPassword.toCharArray());
        identityManager.updateCredential((Agent)adminUser, (Object)password);
        Digest digestPassword = new Digest();
        digestPassword.setRealm("PicketBox Realm");
        digestPassword.setUsername(adminUser.getLoginName());
        digestPassword.setPassword(plainTextPassword);
        identityManager.updateCredential((Agent)adminUser, (Object)digestPassword);
        Digest digest = new Digest();
        digest.setUsername(adminUser.getLoginName());
        digest.setRealm("testrealm@host.com");
        digest.setPassword(plainTextPassword);
        identityManager.updateCredential((Agent)adminUser, (Object)digest);
        SimpleRole roleManager = new SimpleRole("manager");
        identityManager.add((IdentityType)roleManager);
        SimpleRole roleConfidencial = new SimpleRole("confidencial");
        identityManager.add((IdentityType)roleConfidencial);
        SimpleGroup groupCoreDeveloper = new SimpleGroup("PicketBox Group");
        identityManager.add((IdentityType)groupCoreDeveloper);
        identityManager.grantRole((IdentityType)adminUser, (Role)roleManager);
        identityManager.grantRole((IdentityType)adminUser, (Role)roleConfidencial);
        identityManager.addToGroup((IdentityType)adminUser, (Group)groupCoreDeveloper);
    }
}

