/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.authentication;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.infinispan.Cache;
import org.jboss.logging.Logger;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.CacheableManager;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.auth.callback.JBossCallbackHandler;
import org.jboss.security.authentication.SubjectActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossCachedAuthenticationManager
implements AuthenticationManager,
CacheableManager<Cache<Principal, DomainInfo>, Principal> {
    private String securityDomain;
    private CallbackHandler callbackHandler;
    protected Logger log = Logger.getLogger(this.getClass());
    protected boolean trace;
    private transient Method setSecurityInfo;
    protected Cache<Principal, DomainInfo> domainCache;
    private boolean deepCopySubjectOption = false;

    public JBossCachedAuthenticationManager() {
        this("other", (CallbackHandler)new JBossCallbackHandler());
    }

    public JBossCachedAuthenticationManager(String securityDomain, CallbackHandler callbackHandler) {
        this.securityDomain = securityDomain;
        this.callbackHandler = callbackHandler;
        this.trace = this.log.isTraceEnabled();
        Class[] sig = new Class[]{Principal.class, Object.class};
        try {
            this.setSecurityInfo = callbackHandler.getClass().getMethod("setSecurityInfo", sig);
        }
        catch (Exception e) {
            String msg = "Failed to find setSecurityInfo(Principal, Object) method in CallbackHandler";
            throw new UndeclaredThrowableException(e, msg);
        }
        if (this.trace) {
            this.log.trace((Object)("CallbackHandler: " + callbackHandler));
        }
    }

    public Subject getActiveSubject() {
        Subject subj = null;
        SecurityContext sc = SecurityContextAssociation.getSecurityContext();
        if (sc != null) {
            subj = sc.getUtil().getSubject();
        }
        return subj;
    }

    public Principal getTargetPrincipal(Principal anotherDomainPrincipal, Map<String, Object> contextMap) {
        throw new RuntimeException("Not implemented yet");
    }

    public boolean isValid(Principal principal, Object credential) {
        return this.isValid(principal, credential, null);
    }

    public boolean isValid(Principal principal, Object credential, Subject activeSubject) {
        DomainInfo cachedEntry = this.getCacheInfo(principal);
        if (this.trace) {
            this.log.trace((Object)("Begin isValid, principal:" + principal + ", cache entry: " + cachedEntry));
        }
        boolean isValid = false;
        if (cachedEntry != null) {
            isValid = this.validateCache(cachedEntry, credential, activeSubject);
        }
        if (!isValid) {
            isValid = this.authenticate(principal, credential, activeSubject);
        }
        if (this.trace) {
            this.log.trace((Object)("End isValid, " + isValid));
        }
        return isValid;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public void flushCache() {
        if (this.trace) {
            this.log.trace((Object)"Flushing all entried from the cache");
        }
        this.domainCache.clear();
    }

    public void flushCache(Principal key) {
        if (this.trace) {
            this.log.trace((Object)("Flushing " + key.getName() + " from cache"));
        }
        this.domainCache.evict((Object)key);
    }

    public void setCache(Cache<Principal, DomainInfo> cache) {
        this.domainCache = cache;
    }

    public boolean containsKey(Principal key) {
        return this.domainCache.containsKey((Object)key);
    }

    public void setDeepCopySubjectOption(Boolean flag) {
        if (this.trace) {
            this.log.trace((Object)("setDeepCopySubjectOption=" + flag));
        }
        this.deepCopySubjectOption = flag;
    }

    private DomainInfo getCacheInfo(Principal principal) {
        if (this.domainCache == null) {
            return null;
        }
        return (DomainInfo)this.domainCache.get((Object)principal);
    }

    private boolean validateCache(DomainInfo info, Object credential, Subject theSubject) {
        if (this.trace) {
            StringBuffer tmp = new StringBuffer("Begin validateCache, info=");
            tmp.append(info.toString());
            tmp.append(";credential.class=");
            if (credential != null) {
                Class<?> c = credential.getClass();
                tmp.append(c.getName());
                tmp.append('@');
                tmp.append(System.identityHashCode(c));
            } else {
                tmp.append("null");
            }
            this.log.trace((Object)tmp.toString());
        }
        Object subjectCredential = info.credential;
        boolean isValid = false;
        if (credential == null || subjectCredential == null) {
            isValid = credential == null && subjectCredential == null;
        } else if (subjectCredential.getClass().isAssignableFrom(credential.getClass())) {
            if (subjectCredential instanceof Comparable) {
                Comparable c = (Comparable)subjectCredential;
                isValid = c.compareTo(credential) == 0;
            } else if (subjectCredential instanceof char[]) {
                char[] a1 = (char[])subjectCredential;
                char[] a2 = (char[])credential;
                isValid = Arrays.equals(a1, a2);
            } else if (subjectCredential instanceof byte[]) {
                byte[] a1 = (byte[])subjectCredential;
                byte[] a2 = (byte[])credential;
                isValid = Arrays.equals(a1, a2);
            } else if (subjectCredential.getClass().isArray()) {
                Object[] a1 = (Object[])subjectCredential;
                Object[] a2 = (Object[])credential;
                isValid = Arrays.equals(a1, a2);
            } else {
                isValid = subjectCredential.equals(credential);
            }
        } else if (subjectCredential instanceof char[] && credential instanceof String) {
            char[] a1 = (char[])subjectCredential;
            char[] a2 = ((String)credential).toCharArray();
            isValid = Arrays.equals(a1, a2);
        } else if (subjectCredential instanceof String && credential instanceof char[]) {
            char[] a1 = ((String)subjectCredential).toCharArray();
            char[] a2 = (char[])credential;
            isValid = Arrays.equals(a1, a2);
        }
        if (isValid && theSubject != null) {
            SubjectActions.copySubject(info.subject, theSubject, false, this.deepCopySubjectOption);
        }
        if (this.trace) {
            this.log.trace((Object)("End validateCache, isValid=" + isValid));
        }
        return isValid;
    }

    private boolean authenticate(Principal principal, Object credential, Subject theSubject) {
        Subject subject = null;
        boolean authenticated = false;
        LoginException authException = null;
        try {
            LoginContext lc = this.defaultLogin(principal, credential);
            subject = lc.getSubject();
            if (subject != null) {
                if (theSubject != null) {
                    SubjectActions.copySubject(subject, theSubject, false, this.deepCopySubjectOption);
                } else {
                    theSubject = subject;
                }
                authenticated = true;
                this.updateCache(lc, subject, principal, credential);
            }
        }
        catch (LoginException e) {
            if (principal != null && principal.getName() != null || this.trace) {
                this.log.trace((Object)"Login failure", (Throwable)e);
            }
            authException = e;
        }
        SubjectActions.setContextInfo("org.jboss.security.exception", authException);
        return authenticated;
    }

    private LoginContext defaultLogin(Principal principal, Object credential) throws LoginException {
        Object[] securityInfo = new Object[]{principal, credential};
        CallbackHandler theHandler = null;
        try {
            theHandler = (CallbackHandler)this.callbackHandler.getClass().newInstance();
            this.setSecurityInfo.invoke((Object)theHandler, securityInfo);
        }
        catch (Throwable e) {
            if (this.trace) {
                this.log.trace((Object)"Failed to create/setSecurityInfo on handler", e);
            }
            LoginException le = new LoginException("Failed to setSecurityInfo on handler");
            le.initCause(e);
            throw le;
        }
        Subject subject = new Subject();
        LoginContext lc = null;
        if (this.trace) {
            this.log.trace((Object)("defaultLogin, principal=" + principal));
        }
        lc = SubjectActions.createLoginContext(this.securityDomain, subject, theHandler);
        lc.login();
        if (this.trace) {
            this.log.trace((Object)("defaultLogin, lc=" + lc + ", subject=" + SubjectActions.toString(subject)));
        }
        return lc;
    }

    private Subject updateCache(LoginContext loginContext, Subject subject, Principal principal, Object credential) {
        if (this.domainCache == null) {
            return subject;
        }
        DomainInfo info = new DomainInfo();
        info.loginContext = loginContext;
        info.subject = new Subject();
        SubjectActions.copySubject(subject, info.subject, true, this.deepCopySubjectOption);
        info.credential = credential;
        if (this.trace) {
            this.log.trace((Object)("updateCache, inputSubject=" + SubjectActions.toString(subject) + ", cacheSubject=" + SubjectActions.toString(info.subject)));
        }
        Set<Group> subjectGroups = subject.getPrincipals(Group.class);
        for (Group grp : subjectGroups) {
            Enumeration members;
            String name = grp.getName();
            if (!name.equals("CallerPrincipal") || !(members = grp.members()).hasMoreElements()) continue;
            info.callerPrincipal = (Principal)members.nextElement();
        }
        if (info.callerPrincipal == null) {
            Set<Principal> subjectPrincipals = subject.getPrincipals(Principal.class);
            for (Principal p : subjectPrincipals) {
                if (p instanceof Group) continue;
                info.callerPrincipal = p;
                break;
            }
        }
        this.domainCache.put((Object)info.callerPrincipal, (Object)info);
        if (this.trace) {
            this.log.trace((Object)("Inserted cache info: " + info));
        }
        return info.subject;
    }

    public static class DomainInfo
    implements Serializable {
        private static final long serialVersionUID = 7402775370244483773L;
        protected LoginContext loginContext;
        protected Subject subject;
        protected Object credential;
        protected Principal callerPrincipal;
    }
}

