/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.authentication;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.CacheableManager;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.callback.JBossCallbackHandler;
import org.jboss.security.auth.login.BaseAuthenticationInfo;
import org.jboss.security.authentication.SubjectActions;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.SecurityConfiguration;
import org.jboss.security.plugins.ClassLoaderLocator;
import org.jboss.security.plugins.ClassLoaderLocatorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossCachedAuthenticationManager
implements AuthenticationManager,
CacheableManager<ConcurrentMap<Principal, DomainInfo>, Principal> {
    private String securityDomain;
    private CallbackHandler callbackHandler;
    private transient Method setSecurityInfo;
    protected ConcurrentMap<Principal, DomainInfo> domainCache;
    private boolean deepCopySubjectOption = false;

    public JBossCachedAuthenticationManager() {
        this("other", (CallbackHandler)new JBossCallbackHandler());
    }

    public JBossCachedAuthenticationManager(String securityDomain, CallbackHandler callbackHandler) {
        this.securityDomain = securityDomain;
        this.callbackHandler = callbackHandler;
        Class[] sig = new Class[]{Principal.class, Object.class};
        try {
            this.setSecurityInfo = callbackHandler.getClass().getMethod("setSecurityInfo", sig);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(PicketBoxMessages.MESSAGES.unableToFindSetSecurityInfoMessage());
        }
    }

    public Subject getActiveSubject() {
        Subject subj = null;
        SecurityContext sc = SecurityContextAssociation.getSecurityContext();
        if (sc != null) {
            subj = sc.getUtil().getSubject();
        }
        return subj;
    }

    public Principal getTargetPrincipal(Principal anotherDomainPrincipal, Map<String, Object> contextMap) {
        throw new UnsupportedOperationException();
    }

    public boolean isValid(Principal principal, Object credential) {
        return this.isValid(principal, credential, null);
    }

    public boolean isValid(Principal principal, Object credential, Subject activeSubject) {
        DomainInfo cachedEntry = this.getCacheInfo(principal != null ? principal : new SimplePrincipal("null"));
        PicketBoxLogger.LOGGER.traceBeginIsValid(principal, cachedEntry != null ? cachedEntry.toString() : null);
        boolean isValid = false;
        if (cachedEntry != null) {
            isValid = this.validateCache(cachedEntry, credential, activeSubject);
        }
        if (!isValid) {
            isValid = this.authenticate(principal, credential, activeSubject);
        }
        PicketBoxLogger.LOGGER.traceEndIsValid(isValid);
        return isValid;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public void flushCache() {
        PicketBoxLogger.LOGGER.traceFlushWholeCache();
        if (this.domainCache != null) {
            this.domainCache.clear();
        }
    }

    public void flushCache(Principal key) {
        if (this.domainCache != null && key != null) {
            PicketBoxLogger.LOGGER.traceFlushCacheEntry(key.getName());
            this.domainCache.remove(key);
        }
    }

    public void setCache(ConcurrentMap<Principal, DomainInfo> cache) {
        this.domainCache = cache;
    }

    public boolean containsKey(Principal key) {
        if (this.domainCache != null && key != null) {
            return this.domainCache.containsKey(key);
        }
        return false;
    }

    public Set<Principal> getCachedKeys() {
        if (this.domainCache != null) {
            return this.domainCache.keySet();
        }
        return null;
    }

    public void setDeepCopySubjectOption(Boolean flag) {
        this.deepCopySubjectOption = flag;
    }

    private DomainInfo getCacheInfo(Principal principal) {
        if (this.domainCache != null && principal != null) {
            return (DomainInfo)this.domainCache.get(principal);
        }
        return null;
    }

    private boolean validateCache(DomainInfo info, Object credential, Subject theSubject) {
        PicketBoxLogger.LOGGER.traceBeginValidateCache(info.toString(), credential != null ? credential.getClass() : null);
        Object subjectCredential = info.credential;
        boolean isValid = false;
        if (credential == null || subjectCredential == null) {
            isValid = credential == null && subjectCredential == null;
        } else if (subjectCredential.getClass().isAssignableFrom(credential.getClass())) {
            if (subjectCredential instanceof Comparable) {
                Comparable c = (Comparable)subjectCredential;
                isValid = c.compareTo(credential) == 0;
            } else if (subjectCredential instanceof char[]) {
                char[] a1 = (char[])subjectCredential;
                char[] a2 = (char[])credential;
                isValid = Arrays.equals(a1, a2);
            } else if (subjectCredential instanceof byte[]) {
                byte[] a1 = (byte[])subjectCredential;
                byte[] a2 = (byte[])credential;
                isValid = Arrays.equals(a1, a2);
            } else if (subjectCredential.getClass().isArray()) {
                Object[] a1 = (Object[])subjectCredential;
                Object[] a2 = (Object[])credential;
                isValid = Arrays.equals(a1, a2);
            } else {
                isValid = subjectCredential.equals(credential);
            }
        } else if (subjectCredential instanceof char[] && credential instanceof String) {
            char[] a1 = (char[])subjectCredential;
            char[] a2 = ((String)credential).toCharArray();
            isValid = Arrays.equals(a1, a2);
        } else if (subjectCredential instanceof String && credential instanceof char[]) {
            char[] a1 = ((String)subjectCredential).toCharArray();
            char[] a2 = (char[])credential;
            isValid = Arrays.equals(a1, a2);
        }
        if (isValid && theSubject != null) {
            SubjectActions.copySubject(info.subject, theSubject, false, this.deepCopySubjectOption);
        }
        PicketBoxLogger.LOGGER.traceEndValidteCache(isValid);
        return isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean authenticate(Principal principal, Object credential, Subject theSubject) {
        BaseAuthenticationInfo authInfo;
        String jbossModuleName;
        ApplicationPolicy theAppPolicy = SecurityConfiguration.getApplicationPolicy((String)this.securityDomain);
        if (theAppPolicy != null && (jbossModuleName = (authInfo = theAppPolicy.getAuthenticationInfo()).getJBossModuleName()) != null) {
            ClassLoader newTCCL;
            ClassLoader currentTccl = SubjectActions.getContextClassLoader();
            ClassLoaderLocator theCLL = ClassLoaderLocatorFactory.get();
            if (theCLL != null && (newTCCL = theCLL.get(jbossModuleName)) != null) {
                try {
                    SubjectActions.setContextClassLoader(newTCCL);
                    boolean bl = this.proceedWithJaasLogin(principal, credential, theSubject);
                    return bl;
                }
                finally {
                    SubjectActions.setContextClassLoader(currentTccl);
                }
            }
        }
        return this.proceedWithJaasLogin(principal, credential, theSubject);
    }

    private boolean proceedWithJaasLogin(Principal principal, Object credential, Subject theSubject) {
        Subject subject = null;
        boolean authenticated = false;
        LoginException authException = null;
        try {
            LoginContext lc = this.defaultLogin(principal, credential);
            subject = lc.getSubject();
            if (subject != null) {
                if (theSubject != null) {
                    SubjectActions.copySubject(subject, theSubject, false, this.deepCopySubjectOption);
                } else {
                    theSubject = subject;
                }
                authenticated = true;
                this.updateCache(lc, subject, principal, credential);
            }
        }
        catch (LoginException e) {
            if (principal != null && principal.getName() != null) {
                PicketBoxLogger.LOGGER.debugFailedLogin((Throwable)e);
            }
            authException = e;
        }
        SubjectActions.setContextInfo("org.jboss.security.exception", authException);
        return authenticated;
    }

    private LoginContext defaultLogin(Principal principal, Object credential) throws LoginException {
        Object[] securityInfo = new Object[]{principal, credential};
        CallbackHandler theHandler = null;
        try {
            theHandler = (CallbackHandler)this.callbackHandler.getClass().newInstance();
            this.setSecurityInfo.invoke((Object)theHandler, securityInfo);
        }
        catch (Throwable e) {
            LoginException le = new LoginException(PicketBoxMessages.MESSAGES.unableToFindSetSecurityInfoMessage());
            le.initCause(e);
            throw le;
        }
        Subject subject = new Subject();
        LoginContext lc = null;
        PicketBoxLogger.LOGGER.traceDefaultLoginPrincipal(principal);
        lc = SubjectActions.createLoginContext(this.securityDomain, subject, theHandler);
        lc.login();
        PicketBoxLogger.LOGGER.traceDefaultLoginSubject(lc.toString(), SubjectActions.toString(subject));
        return lc;
    }

    private Subject updateCache(LoginContext loginContext, Subject subject, Principal principal, Object credential) {
        if (this.domainCache == null) {
            return subject;
        }
        DomainInfo info = new DomainInfo();
        info.loginContext = loginContext;
        info.subject = new Subject();
        SubjectActions.copySubject(subject, info.subject, true, this.deepCopySubjectOption);
        info.credential = credential;
        PicketBoxLogger.LOGGER.traceUpdateCache(SubjectActions.toString(subject), SubjectActions.toString(info.subject));
        Set<Group> subjectGroups = subject.getPrincipals(Group.class);
        for (Group grp : subjectGroups) {
            Enumeration members;
            String name = grp.getName();
            if (!name.equals("CallerPrincipal") || !(members = grp.members()).hasMoreElements()) continue;
            info.callerPrincipal = (Principal)members.nextElement();
        }
        if (info.callerPrincipal == null) {
            Set<Principal> subjectPrincipals = subject.getPrincipals(Principal.class);
            for (Principal p : subjectPrincipals) {
                if (p instanceof Group) continue;
                info.callerPrincipal = p;
                break;
            }
        }
        this.domainCache.put(principal != null ? principal : new SimplePrincipal("null"), info);
        PicketBoxLogger.LOGGER.traceInsertedCacheInfo(info.toString());
        return info.subject;
    }

    public static class DomainInfo
    implements Serializable {
        private static final long serialVersionUID = 7402775370244483773L;
        protected LoginContext loginContext;
        protected Subject subject;
        protected Object credential;
        protected Principal callerPrincipal;

        public void logout() {
            if (this.loginContext != null) {
                try {
                    this.loginContext.logout();
                }
                catch (Exception e) {
                    PicketBoxLogger.LOGGER.traceCacheEntryLogoutFailure((Throwable)e);
                }
            }
        }
    }
}

