/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.ldap;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DefaultDirectoryService;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmPartition;
import org.apache.directory.server.core.partition.ldif.LdifPartition;
import org.apache.directory.server.core.schema.SchemaPartition;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.directory.shared.ldap.entry.DefaultServerEntry;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.ldif.LdifEntry;
import org.apache.directory.shared.ldap.ldif.LdifReader;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.ldif.extractor.impl.DefaultSchemaLdifExtractor;
import org.apache.directory.shared.ldap.schema.loader.ldif.LdifSchemaLoader;
import org.apache.directory.shared.ldap.schema.manager.impl.DefaultSchemaManager;
import org.apache.directory.shared.ldap.schema.registries.SchemaLoader;

public class EmbeddedApacheDS {
    private DirectoryService service = new DefaultDirectoryService();
    private LdapServer server;

    public EmbeddedApacheDS(File workDir) throws Exception {
        this.service.setWorkingDirectory(workDir);
        this.initSchemaPartition();
        Partition systemPartition = this.addPartition("system", "ou=system");
        this.service.setSystemPartition(systemPartition);
        this.service.getChangeLog().setEnabled(false);
        this.service.setDenormalizeOpAttrsEnabled(true);
    }

    public void createBaseDN(String partitionName, String baseDN) throws Exception {
        Partition partition = this.addPartition(partitionName, baseDN);
        this.service.startup();
    }

    private Partition addPartition(String partitionId, String partitionDn) throws Exception {
        JdbmPartition partition = new JdbmPartition();
        partition.setId(partitionId);
        partition.setPartitionDir(new File(this.service.getWorkingDirectory(), partitionId));
        partition.setSuffix(partitionDn);
        this.service.addPartition((Partition)partition);
        return partition;
    }

    private void initSchemaPartition() throws Exception {
        SchemaPartition schemaPartition = this.service.getSchemaService().getSchemaPartition();
        LdifPartition ldifPartition = new LdifPartition();
        String workingDirectory = this.service.getWorkingDirectory().getPath();
        ldifPartition.setWorkingDirectory(workingDirectory + "/schema");
        File schemaRepository = new File(workingDirectory, "schema");
        DefaultSchemaLdifExtractor extractor = new DefaultSchemaLdifExtractor(new File(workingDirectory));
        extractor.extractOrCopy(true);
        schemaPartition.setWrappedPartition((Partition)ldifPartition);
        LdifSchemaLoader loader = new LdifSchemaLoader(schemaRepository);
        DefaultSchemaManager schemaManager = new DefaultSchemaManager((SchemaLoader)loader);
        this.service.setSchemaManager((SchemaManager)schemaManager);
        schemaManager.loadAllEnabled();
        schemaPartition.setSchemaManager((SchemaManager)schemaManager);
        List errors = schemaManager.getErrors();
        if (errors.size() != 0) {
            throw new Exception("Schema load failed : " + errors);
        }
    }

    public void importLdif(InputStream in) throws Exception {
        CoreSession rootDSE = this.service.getAdminSession();
        for (LdifEntry ldifEntry : new LdifReader(in)) {
            DefaultServerEntry entry = new DefaultServerEntry(rootDSE.getDirectoryService().getSchemaManager(), ldifEntry.getEntry());
            if (rootDSE.exists(entry.getDn())) continue;
            rootDSE.add((ServerEntry)entry);
        }
    }

    public void startServer() throws Exception {
        this.server = new LdapServer();
        int serverPort = 10389;
        this.server.setTransports(new Transport[]{new TcpTransport(serverPort)});
        this.server.setDirectoryService(this.service);
        this.server.start();
    }

    public void stopServer() throws Exception {
        if (this.server != null && this.server.isStarted()) {
            this.server.stop();
        }
    }
}

