/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.http.quickstarts.idm;

import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.picketbox.core.PicketBoxManager;
import org.picketbox.http.quickstarts.idm.RegistrationRequest;
import org.picketbox.http.quickstarts.idm.RegistrationResponse;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.credential.PlainTextPassword;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleRole;
import org.picketlink.idm.model.SimpleUser;

@Path(value="/register")
public class RegistrationEndpoint {
    @Context
    private ServletContext servletContext;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public RegistrationResponse register(RegistrationRequest request) {
        RegistrationResponse response = new RegistrationResponse();
        if (!this.validateUserInformation(request)) {
            response.setStatus("All fields are required.");
            return response;
        }
        if (!request.getPassword().equals(request.getConfirmPassword())) {
            response.setStatus("Password mismatch.");
            return response;
        }
        if (this.isUsernameAlreadyInUse(request)) {
            SimpleUser user = new SimpleUser(request.getUserName());
            user.setFirstName(request.getFirstName());
            user.setEmail(request.getEmail());
            user.setLastName(request.getLastName());
            IdentityManager identityManager = this.getIdentityManager();
            identityManager.add((IdentityType)user);
            PlainTextPassword password = new PlainTextPassword(request.getPassword().toCharArray());
            password.setEncodePassword(false);
            identityManager.updateCredential((Agent)user, (Object)password);
            Role roleGuest = identityManager.getRole("guest");
            if (roleGuest == null) {
                roleGuest = new SimpleRole("guest");
                identityManager.add((IdentityType)roleGuest);
            }
            identityManager.grantRole((IdentityType)user, roleGuest);
            response.setStatus("Success");
        } else {
            response.setStatus("This username is already in use. Choose another one.");
        }
        return response;
    }

    private boolean isUsernameAlreadyInUse(RegistrationRequest request) {
        return this.getIdentityManager().getUser(request.getUserName()) == null;
    }

    public boolean validateUserInformation(RegistrationRequest request) {
        String username = request.getUserName();
        String password = request.getPassword();
        String confirmPassword = request.getConfirmPassword();
        String email = request.getEmail();
        String firstName = request.getFirstName();
        String lastName = request.getLastName();
        return !"".equals(username.trim()) && !"".equals(password.trim()) && !"".equals(confirmPassword.trim()) && !"".equals(firstName.trim()) && !"".equals(lastName.trim()) && !"".equals(email.trim());
    }

    private IdentityManager getIdentityManager() {
        PicketBoxManager picketBoxManager = (PicketBoxManager)this.servletContext.getAttribute("PICKETBOX_MANAGER");
        return picketBoxManager.getIdentityManager();
    }
}

