/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.http.quickstarts.idm;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.picketbox.core.PicketBoxManager;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.credential.PlainTextPassword;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleRole;
import org.picketlink.idm.model.SimpleUser;
import org.picketlink.idm.model.User;

@WebServlet(urlPatterns={"/signup"})
public class SignUpServlet
extends HttpServlet {
    private static final String ROLE_GUEST = "guest";
    private static final long serialVersionUID = 7251985700185294184L;

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String username = req.getParameter("username");
        String firstName = req.getParameter("firstName");
        String lastName = req.getParameter("lastName");
        String email = req.getParameter("email");
        String password = req.getParameter("password");
        String confirmPassword = req.getParameter("confirmPassword");
        SimpleUser user = new SimpleUser(username);
        user.setFirstName(firstName);
        user.setLastName(lastName);
        user.setEmail(email);
        String validationMessage = this.validateUser((User)user);
        if (validationMessage == null) {
            validationMessage = this.validatePassword(password, confirmPassword);
        }
        if (validationMessage != null) {
            req.getSession().setAttribute("message", (Object)validationMessage);
            req.getRequestDispatcher("/signup.jsp").forward((ServletRequest)req, (ServletResponse)resp);
        } else {
            IdentityManager identityManager = this.getIdentityManager(req);
            identityManager.add((IdentityType)user);
            PlainTextPassword credential = new PlainTextPassword(password.toCharArray());
            identityManager.updateCredential((Agent)user, (Object)credential);
            Role guestRole = identityManager.getRole(ROLE_GUEST);
            if (guestRole == null) {
                guestRole = new SimpleRole(ROLE_GUEST);
                identityManager.add((IdentityType)guestRole);
            }
            identityManager.grantRole((IdentityType)user, guestRole);
            resp.sendRedirect("login.jsp?signin=true");
        }
    }

    private String validatePassword(String password, String confirmation) {
        String validationMessage = null;
        if ("".equals(password.trim())) {
            validationMessage = "Your Password is required.";
        }
        if (!password.equals(confirmation)) {
            validationMessage = "Password mismatch.";
        }
        return validationMessage;
    }

    private String validateUser(User user) {
        String validationMessage = null;
        if (user.getId() == null || "".equals(user.getId().trim())) {
            validationMessage = "Choose a User ID.";
        } else if (user.getFirstName() == null || "".equals(user.getFirstName().trim())) {
            validationMessage = "Your First Name is required.";
        } else if (user.getLastName() != null || "".equals(user.getLastName().trim())) {
            validationMessage = "Your Last Name is required.";
        } else if (user.getEmail() != null || "".equals(user.getEmail().trim())) {
            validationMessage = "Your Email is required.";
        }
        return validationMessage;
    }

    private IdentityManager getIdentityManager(HttpServletRequest req) {
        PicketBoxManager picketBoxManager = (PicketBoxManager)req.getServletContext().getAttribute("PICKETBOX_MANAGER");
        return picketBoxManager.getIdentityManager();
    }
}

