/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2012, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.picketbox.solder;

import java.io.IOException;

import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;

import org.picketbox.http.PicketBoxHTTPManager;
import org.picketbox.http.authentication.HTTPAuthenticationScheme;
import org.picketbox.http.filters.DelegatingSecurityFilter;
import org.picketbox.solder.authentication.AuthenticationScheme;

/**
 * <p>
 * This filter only delegates to the {@link DelegatingSecurityFilter} the request processing.
 * </p>
 *
 * @author <a href="mailto:psilva@redhat.com">Pedro Silva</a>
 *
 */
@WebFilter (filterName = "PicketBoxSecurityFilter",
urlPatterns = {"/*"})
public class PicketBoxSecurityFilter implements Filter {

    private DelegatingSecurityFilter delegatingSecurityFilter;

    @Inject
    private PicketBoxHTTPManager securityManager;

    @Inject
    @AuthenticationScheme
    private HTTPAuthenticationScheme authenticationScheme;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        this.delegatingSecurityFilter = new DelegatingSecurityFilter(this.authenticationScheme, this.securityManager);
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException,
            ServletException {
        this.delegatingSecurityFilter.doFilter(request, response, chain);
    }

    @Override
    public void destroy() {
        this.delegatingSecurityFilter.destroy();
    }

}