/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.store.hibernate;

import java.util.logging.Logger;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.api.IdentitySessionFactory;
import org.picketlink.idm.impl.api.APITestContext;
import org.picketlink.idm.impl.configuration.IdentityConfigurationImpl;
import org.picketlink.idm.test.support.hibernate.HibernateTestPOJO;

public class SimpleTestCase
extends HibernateTestPOJO
implements APITestContext {
    private static Logger log = Logger.getLogger(SimpleTestCase.class.getName());
    IdentitySessionFactory identitySessionFactory;

    public void setUp() throws Exception {
        super.start();
        this.setRealmName("realm://RedHat/DB");
        this.identitySessionFactory = new IdentityConfigurationImpl().configure(this.getIdentityConfig()).buildIdentitySessionFactory();
        log.fine("Statistics after IdentitySessionFactory creation:");
        this.hibernateSupport.getSessionFactory().getStatistics().logSummary();
    }

    public void tearDown() throws Exception {
        super.stop();
    }

    public IdentitySessionFactory getIdentitySessionFactory() {
        return this.identitySessionFactory;
    }

    public void testPersistenceManager() throws Exception {
        int i;
        int i2;
        IdentitySession session = this.identitySessionFactory.createIdentitySession(this.getRealmName());
        String ORGANIZATION = "ORGANIZATION";
        for (i2 = 0; i2 < 50; ++i2) {
            log.fine("\n\n\n### Create Group: " + i2 + "\n");
            this.begin();
            session.getPersistenceManager().createGroup("test" + i2, ORGANIZATION);
            this.commit();
        }
        for (i2 = 0; i2 < 50; ++i2) {
            log.fine("\n\n\n### Create User: " + i2 + "\n");
            this.begin();
            session.getPersistenceManager().createUser("test" + i2);
            this.commit();
        }
        String groupKey = session.getPersistenceManager().createGroupKey("test0", ORGANIZATION);
        for (i = 0; i < 50; ++i) {
            log.fine("\n\n\n### Associate User[" + i + "] to a Group" + "\n");
            this.begin();
            session.getRelationshipManager().associateUserByKeys(groupKey, "test" + i);
            this.commit();
        }
        this.begin();
        groupKey = session.getPersistenceManager().createGroup("master", ORGANIZATION).getKey();
        this.commit();
        for (i = 0; i < 50; ++i) {
            log.fine("\n\n\n### Associate Group[" + i + "] of type DEPARTMENT to a Group" + groupKey + "\n");
            this.begin();
            String groupKey2 = session.getPersistenceManager().createGroupKey("test" + i, ORGANIZATION);
            session.getRelationshipManager().associateGroupsByKeys(groupKey, groupKey2);
            this.commit();
        }
    }
}

