/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.store.hibernate;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.manager.DefaultCacheManager;
import org.picketlink.idm.api.Attribute;
import org.picketlink.idm.api.AttributesManager;
import org.picketlink.idm.api.Group;
import org.picketlink.idm.api.IdentitySearchCriteria;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.api.IdentitySessionFactory;
import org.picketlink.idm.api.IdentityType;
import org.picketlink.idm.api.PersistenceManager;
import org.picketlink.idm.api.RelationshipManager;
import org.picketlink.idm.api.RoleManager;
import org.picketlink.idm.api.RoleType;
import org.picketlink.idm.api.UnsupportedCriterium;
import org.picketlink.idm.api.User;
import org.picketlink.idm.api.cfg.IdentityConfiguration;
import org.picketlink.idm.cache.APICacheProvider;
import org.picketlink.idm.cache.GroupSearch;
import org.picketlink.idm.cache.RelationshipSearch;
import org.picketlink.idm.cache.RoleSearch;
import org.picketlink.idm.cache.RoleTypeSearch;
import org.picketlink.idm.common.exception.FeatureNotSupportedException;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.impl.api.IdentitySearchCriteriaImpl;
import org.picketlink.idm.impl.api.SimpleAttribute;
import org.picketlink.idm.impl.api.model.SimpleGroup;
import org.picketlink.idm.impl.api.model.SimpleRoleType;
import org.picketlink.idm.impl.api.model.SimpleUser;
import org.picketlink.idm.impl.cache.GroupSearchImpl;
import org.picketlink.idm.impl.cache.InfinispanAPICacheProviderImpl;
import org.picketlink.idm.impl.cache.RelationshipSearchImpl;
import org.picketlink.idm.impl.cache.RoleSearchImpl;
import org.picketlink.idm.impl.cache.RoleTypeSearchImpl;
import org.picketlink.idm.impl.configuration.IdentityConfigurationImpl;
import org.picketlink.idm.test.support.hibernate.HibernateTestPOJO;

public class APICacheIntegrationTestCase
extends HibernateTestPOJO {
    private IdentitySession identitySession;
    private APICacheProvider apiCacheProvider;
    private static final String REALM_NAME = "realm://FlexibleRealm";

    public void setUp() throws Exception {
        super.start();
        this.setIdentityConfig("cache-identity-config.xml");
        this.setRealmName(REALM_NAME);
        IdentityConfiguration identityConfiguration = new IdentityConfigurationImpl().configure(this.getIdentityConfig());
        DefaultCacheManager manager = new DefaultCacheManager("infinispan.xml", true);
        Cache infinispanCache = manager.getCache("xml-configured-cache");
        InfinispanAPICacheProviderImpl cacheProvider = new InfinispanAPICacheProviderImpl();
        cacheProvider.initialize(infinispanCache, false, -1L, 1000L);
        this.apiCacheProvider = cacheProvider;
        identityConfiguration.getIdentityConfigurationRegistry().register((Object)this.apiCacheProvider, "apiCacheProvider");
        IdentitySessionFactory identitySessionFactory = identityConfiguration.buildIdentitySessionFactory();
        this.identitySession = identitySessionFactory.createIdentitySession(REALM_NAME);
    }

    public void tearDown() throws Exception {
        super.stop();
    }

    public void testApiCacheIntegration() throws IdentityException, UnsupportedCriterium, FeatureNotSupportedException {
        this._testPersistenceManager();
        this._testAttributesManager();
        this._testRelationshipManager();
        this._testRoleManager();
    }

    private void _testPersistenceManager() throws IdentityException, UnsupportedCriterium {
        PersistenceManager pm = this.identitySession.getPersistenceManager();
        pm.createUser("john");
        IdentitySearchCriteria searchCriteria = new IdentitySearchCriteriaImpl().nameFilter("john");
        pm.findUser(searchCriteria);
        pm.getUserCount();
        APICacheIntegrationTestCase.assertNotNull((Object)this.apiCacheProvider.getUser(REALM_NAME, "john"));
        APICacheIntegrationTestCase.assertNotNull((Object)this.apiCacheProvider.getUsers(REALM_NAME, searchCriteria));
        APICacheIntegrationTestCase.assertEquals((int)1, (int)this.apiCacheProvider.getUserCount(REALM_NAME));
        pm.createUser("demo");
        APICacheIntegrationTestCase.assertNotNull((Object)this.apiCacheProvider.getUser(REALM_NAME, "demo"));
        APICacheIntegrationTestCase.assertNull((Object)this.apiCacheProvider.getUser(REALM_NAME, "john"));
        APICacheIntegrationTestCase.assertNull((Object)this.apiCacheProvider.getUsers(REALM_NAME, searchCriteria));
        APICacheIntegrationTestCase.assertEquals((int)-1, (int)this.apiCacheProvider.getUserCount(REALM_NAME));
        pm.createGroup("mygroup", "mygrouptype");
        pm.findGroup("mygrouptype");
        pm.findGroup("nonExistingGroupType");
        pm.getGroupTypeCount("nonExistingGroupType");
        GroupSearchImpl search = new GroupSearchImpl();
        search.setGroupType("mygrouptype");
        GroupSearchImpl searchNonExisting = new GroupSearchImpl();
        searchNonExisting.setGroupType("nonExistingGroupType");
        APICacheIntegrationTestCase.assertNotNull((Object)this.apiCacheProvider.getGroupSearch(REALM_NAME, (GroupSearch)search));
        APICacheIntegrationTestCase.assertNotNull((Object)this.apiCacheProvider.getGroupSearch(REALM_NAME, (GroupSearch)searchNonExisting));
        APICacheIntegrationTestCase.assertNotNull((Object)this.apiCacheProvider.getGroup(REALM_NAME, "mygrouptype", "mygroup"));
        APICacheIntegrationTestCase.assertEquals((int)0, (int)this.apiCacheProvider.getGroupCount(REALM_NAME, "nonExistingGroupType"));
        APICacheIntegrationTestCase.assertEquals((int)-1, (int)this.apiCacheProvider.getGroupCount(REALM_NAME, "mygrouptype"));
        APICacheIntegrationTestCase.assertNull((Object)this.apiCacheProvider.getUser(REALM_NAME, "demo"));
        pm.removeGroup((Group)new SimpleGroup("mygroup", "mygrouptype"), true);
        APICacheIntegrationTestCase.assertNull((Object)this.apiCacheProvider.getGroupSearch(REALM_NAME, (GroupSearch)searchNonExisting));
        APICacheIntegrationTestCase.assertNull((Object)this.apiCacheProvider.getGroup(REALM_NAME, "mygrouptype", "mygroup"));
        APICacheIntegrationTestCase.assertEquals((int)-1, (int)this.apiCacheProvider.getGroupCount(REALM_NAME, "nonExistingGroupType"));
    }

    private void _testAttributesManager() throws IdentityException {
        AttributesManager am = this.identitySession.getAttributesManager();
        am.getAttributes("demo");
        am.getAttributes("john");
        APICacheIntegrationTestCase.assertEquals((int)0, (int)this.apiCacheProvider.getAttributes(REALM_NAME, "demo").size());
        APICacheIntegrationTestCase.assertEquals((int)0, (int)this.apiCacheProvider.getAttributes(REALM_NAME, "john").size());
        APICacheIntegrationTestCase.assertNull((Object)this.apiCacheProvider.getAttributes(REALM_NAME, "nonExisting"));
        am.addAttribute("john", "surname", (Object)"Anthony");
        APICacheIntegrationTestCase.assertEquals((int)1, (int)this.apiCacheProvider.getAttributes(REALM_NAME, "john").size());
        SimpleAttribute johnSurname = new SimpleAttribute("surname", (Object)"Antonin");
        am.updateAttributes("john", new Attribute[]{johnSurname});
        Map johnAttrsFromCache = this.apiCacheProvider.getAttributes(REALM_NAME, "john");
        APICacheIntegrationTestCase.assertEquals((int)1, (int)johnAttrsFromCache.size());
        Attribute surnameFromCache = (Attribute)johnAttrsFromCache.get("surname");
        APICacheIntegrationTestCase.assertNotNull((Object)surnameFromCache);
        APICacheIntegrationTestCase.assertEquals((Object)johnSurname.getValue(), (Object)surnameFromCache.getValue());
        am.removeAttributes("john", new String[]{"surname"});
        APICacheIntegrationTestCase.assertEquals((int)0, (int)this.apiCacheProvider.getAttributes(REALM_NAME, "john").size());
    }

    private void _testRelationshipManager() throws IdentityException {
        PersistenceManager pm = this.identitySession.getPersistenceManager();
        RelationshipManager relm = this.identitySession.getRelationshipManager();
        SimpleUser john = new SimpleUser("john");
        IdentitySearchCriteriaImpl emptyCriteria = new IdentitySearchCriteriaImpl();
        Group group1 = pm.createGroup("mygroup1", "mygrouptype");
        Group group2 = pm.createGroup("mygroup2", "mygrouptype");
        Group group3 = pm.createGroup("mygroup3", "mygrouptype");
        relm.associateGroups(group1, group2);
        APICacheIntegrationTestCase.assertTrue((boolean)relm.isAssociated((IdentityType)group1, (IdentityType)group2));
        APICacheIntegrationTestCase.assertFalse((boolean)relm.isAssociated((IdentityType)group2, (IdentityType)group3));
        RelationshipSearchImpl search12 = new RelationshipSearchImpl();
        search12.addParent((IdentityType)group1);
        search12.addMember((IdentityType)group2);
        RelationshipSearchImpl search23 = new RelationshipSearchImpl();
        search23.addParent((IdentityType)group2);
        search23.addMember((IdentityType)group3);
        RelationshipSearchImpl search13 = new RelationshipSearchImpl();
        search13.addParent((IdentityType)group1);
        search13.addMember((IdentityType)group3);
        APICacheIntegrationTestCase.assertTrue((boolean)this.apiCacheProvider.getRelationshipSearch(REALM_NAME, (RelationshipSearch)search12));
        APICacheIntegrationTestCase.assertFalse((boolean)this.apiCacheProvider.getRelationshipSearch(REALM_NAME, (RelationshipSearch)search23));
        APICacheIntegrationTestCase.assertNull((Object)this.apiCacheProvider.getRelationshipSearch(REALM_NAME, (RelationshipSearch)search13));
        APICacheIntegrationTestCase.assertEquals((int)1, (int)relm.findAssociatedGroups(group1, "mygrouptype", true, true, (IdentitySearchCriteria)emptyCriteria).size());
        GroupSearchImpl groupSearch = new GroupSearchImpl();
        groupSearch.addAssociatedGroupId(group1.getKey());
        groupSearch.setGroupType("mygrouptype");
        groupSearch.setParent(Boolean.valueOf(true));
        groupSearch.setCascade(Boolean.valueOf(true));
        groupSearch.setSearchCriteria((IdentitySearchCriteria)emptyCriteria);
        APICacheIntegrationTestCase.assertTrue((boolean)this.apiCacheProvider.getGroupSearch(REALM_NAME, (GroupSearch)groupSearch).contains(group2));
        relm.associateUser(group1, (User)john);
        APICacheIntegrationTestCase.assertNull((Object)this.apiCacheProvider.getRelationshipSearch(REALM_NAME, (RelationshipSearch)search12));
        APICacheIntegrationTestCase.assertNull((Object)this.apiCacheProvider.getRelationshipSearch(REALM_NAME, (RelationshipSearch)search23));
        APICacheIntegrationTestCase.assertNull((Object)this.apiCacheProvider.getRelationshipSearch(REALM_NAME, (RelationshipSearch)search13));
        APICacheIntegrationTestCase.assertNull((Object)this.apiCacheProvider.getGroupSearch(REALM_NAME, (GroupSearch)groupSearch));
        APICacheIntegrationTestCase.assertTrue((boolean)relm.isAssociated((IdentityType)group1, (IdentityType)john));
        RelationshipSearchImpl search1j = new RelationshipSearchImpl();
        search1j.addParent((IdentityType)group1);
        search1j.addMember((IdentityType)john);
        APICacheIntegrationTestCase.assertTrue((boolean)this.apiCacheProvider.getRelationshipSearch(REALM_NAME, (RelationshipSearch)search1j));
        relm.disassociateGroups(group1, Arrays.asList(group2));
        APICacheIntegrationTestCase.assertNull((Object)this.apiCacheProvider.getRelationshipSearch(REALM_NAME, (RelationshipSearch)search1j));
    }

    private void _testRoleManager() throws FeatureNotSupportedException, IdentityException {
        RoleManager rolman = this.identitySession.getRoleManager();
        SimpleUser john = new SimpleUser("john");
        SimpleGroup group1 = new SimpleGroup("mygroup1", "mygrouptype");
        SimpleGroup group2 = new SimpleGroup("mygroup2", "mygrouptype");
        IdentitySearchCriteriaImpl emptyCriteria = new IdentitySearchCriteriaImpl();
        RoleType rolType1 = rolman.createRoleType("roleType1");
        RoleType rolType2 = rolman.createRoleType("roleType2");
        APICacheIntegrationTestCase.assertNotNull((Object)this.apiCacheProvider.getRoleType(REALM_NAME, rolType2));
        APICacheIntegrationTestCase.assertNull((Object)this.apiCacheProvider.getRoleType(REALM_NAME, (RoleType)new SimpleRoleType("roleTypeNonExisting")));
        rolman.createRole(rolType1, (User)john, (Group)group1);
        rolman.createRole(rolType2, (User)john, (Group)group2);
        rolman.findGroupRoleTypes((Group)group1, (IdentitySearchCriteria)emptyCriteria);
        rolman.findUserRoleTypes((User)john, (IdentitySearchCriteria)emptyCriteria);
        rolman.findGroupsWithRelatedRole("john", "mygrouptype", (IdentitySearchCriteria)emptyCriteria);
        rolman.findRoles((IdentityType)group1, rolType1);
        RoleTypeSearchImpl rts1 = new RoleTypeSearchImpl();
        rts1.setGroup((Group)group1);
        rts1.setSearchCriteria((IdentitySearchCriteria)emptyCriteria);
        RoleTypeSearchImpl rtsUser = new RoleTypeSearchImpl();
        rtsUser.setUser((User)john);
        rtsUser.setSearchCriteria((IdentitySearchCriteria)emptyCriteria);
        APICacheIntegrationTestCase.assertEquals((int)1, (int)this.apiCacheProvider.getRoleTypeSearch(REALM_NAME, (RoleTypeSearch)rts1).size());
        APICacheIntegrationTestCase.assertEquals((int)2, (int)this.apiCacheProvider.getRoleTypeSearch(REALM_NAME, (RoleTypeSearch)rtsUser).size());
        GroupSearchImpl searchRelatedRole = new GroupSearchImpl();
        searchRelatedRole.addRelatedUserId(john.getKey());
        searchRelatedRole.setGroupType("mygrouptype");
        searchRelatedRole.setSearchCriteria((IdentitySearchCriteria)emptyCriteria);
        Collection groupsFromRS = this.apiCacheProvider.getGroupSearch(REALM_NAME, (GroupSearch)searchRelatedRole);
        APICacheIntegrationTestCase.assertEquals((int)2, (int)groupsFromRS.size());
        APICacheIntegrationTestCase.assertTrue((boolean)groupsFromRS.contains(group1));
        APICacheIntegrationTestCase.assertTrue((boolean)groupsFromRS.contains(group2));
        RoleSearchImpl roleSearch = new RoleSearchImpl();
        roleSearch.setIdentityTypeId(group1.getKey());
        roleSearch.setRoleType(rolType1);
        APICacheIntegrationTestCase.assertEquals((int)1, (int)this.apiCacheProvider.getRoleSearch(REALM_NAME, (RoleSearch)roleSearch).size());
        rolman.createRoleType("roleType3");
        APICacheIntegrationTestCase.assertNull((Object)this.apiCacheProvider.getRoleTypeSearch(REALM_NAME, (RoleTypeSearch)rts1));
        APICacheIntegrationTestCase.assertNull((Object)this.apiCacheProvider.getRoleTypeSearch(REALM_NAME, (RoleTypeSearch)rtsUser));
        APICacheIntegrationTestCase.assertNull((Object)this.apiCacheProvider.getGroupSearch(REALM_NAME, (GroupSearch)searchRelatedRole));
        APICacheIntegrationTestCase.assertNull((Object)this.apiCacheProvider.getRoleSearch(REALM_NAME, (RoleSearch)roleSearch));
    }
}

