/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.store.hibernate;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import junit.framework.Assert;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.api.IdentitySessionFactory;
import org.picketlink.idm.api.IdentityType;
import org.picketlink.idm.api.SecureRandomProvider;
import org.picketlink.idm.api.User;
import org.picketlink.idm.api.cfg.IdentityConfiguration;
import org.picketlink.idm.api.cfg.IdentityConfigurationRegistry;
import org.picketlink.idm.impl.api.session.IdentitySessionImpl;
import org.picketlink.idm.impl.configuration.IdentityConfigurationImpl;
import org.picketlink.idm.test.support.hibernate.HibernateTestPOJO;

public class SaltCredentialsEncoderTestCase
extends HibernateTestPOJO {
    IdentitySessionFactory identitySessionFactory;

    public void setUp() throws Exception {
        super.start();
        this.setIdentityConfig("salt-test-config.xml");
        this.setRealmName("realm://SaltTestRealm");
    }

    public void tearDown() throws Exception {
        super.stop();
    }

    public void testDatabaseSaltEncoder() throws Exception {
        this.identitySessionFactory = new IdentityConfigurationImpl().configure(this.getIdentityConfig()).buildIdentitySessionFactory();
        this._testImpl();
    }

    public void testDatabaseSaltEncoderWithRegisteredSecureRandom() throws Exception {
        IdentityConfiguration identityConfiguration = new IdentityConfigurationImpl().configure(this.getIdentityConfig());
        IdentityConfigurationRegistry registry = identityConfiguration.getIdentityConfigurationRegistry();
        registry.register((Object)new TestSecureRandomProvider(), "secureRandomProvider");
        this.identitySessionFactory = identityConfiguration.buildIdentitySessionFactory();
        this._testImpl();
    }

    private void _testImpl() throws Exception {
        this.begin();
        IdentitySession session = this.identitySessionFactory.createIdentitySession(this.getRealmName());
        User theduke = session.getPersistenceManager().createUser("theduke");
        User demo = session.getPersistenceManager().createUser("demo");
        session.getAttributesManager().addAttribute((IdentityType)theduke, "passwordSalt", (Object)"aaabbbcccdddtheduke");
        session.getAttributesManager().updatePassword(theduke, "gtn");
        Assert.assertTrue((boolean)session.getAttributesManager().validatePassword(theduke, "gtn"));
        Assert.assertEquals((String)"57eb0c5a143899270f49bf82fd6db49809b765c138b6752a3bfc4862cdc4d73d", (String)((IdentitySessionImpl)session).getCredentialEncoder().encodeCredential(theduke.getKey(), "gtn"));
        Assert.assertNull((Object)session.getAttributesManager().getAttribute((IdentityType)demo, "passwordSalt"));
        session.getAttributesManager().updatePassword(demo, "password123");
        Assert.assertNotNull((Object)session.getAttributesManager().getAttribute((IdentityType)demo, "passwordSalt"));
        Assert.assertFalse((boolean)session.getAttributesManager().validatePassword(demo, "gtn"));
        Assert.assertFalse((boolean)session.getAttributesManager().validatePassword(demo, "password321"));
        Assert.assertTrue((boolean)session.getAttributesManager().validatePassword(demo, "password123"));
        this.commit();
    }

    private class TestSecureRandomProvider
    implements SecureRandomProvider {
        private TestSecureRandomProvider() {
        }

        public SecureRandom getSecureRandom() {
            try {
                return SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new RuntimeException(nsae);
            }
        }
    }
}

