/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.store.hibernate;

import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.impl.api.session.IdentitySessionImpl;
import org.picketlink.idm.impl.repository.RepositoryIdentityStoreSessionImpl;
import org.picketlink.idm.impl.store.hibernate.HibernateIdentityStoreSessionImpl;
import org.picketlink.idm.impl.store.hibernate.MinimalFlexibleConfigTestCase;

public class LazyTransactionTestCase
extends MinimalFlexibleConfigTestCase {
    @Override
    public void setUp() throws Exception {
        this.setIdentityConfigLocation("lazy-tx-identity-config.xml");
        super.setUp();
    }

    public void testLazyTransaction() throws IdentityException {
        IdentitySessionImpl identitySession = (IdentitySessionImpl)this.identitySessionFactory.getCurrentIdentitySession("realm::FlexibleRealm");
        RepositoryIdentityStoreSessionImpl repositoryStoreSession = (RepositoryIdentityStoreSessionImpl)identitySession.getSessionContext().resolveStoreInvocationContext().getIdentityStoreSession();
        HibernateIdentityStoreSessionImpl hbStoreSession = (HibernateIdentityStoreSessionImpl)repositoryStoreSession.getIdentityStoreSession("Hibernate Identity Store");
        LazyTransactionTestCase.assertNull((Object)hbStoreSession.getHibernateTxStatus());
        LazyTransactionTestCase.assertFalse((boolean)identitySession.getTransaction().isActive());
        identitySession.beginTransaction();
        LazyTransactionTestCase.assertTrue((boolean)identitySession.getTransaction().isActive());
        LazyTransactionTestCase.assertFalse((boolean)hbStoreSession.getHibernateTxStatus());
        identitySession.getPersistenceManager().findUser("someone");
        LazyTransactionTestCase.assertTrue((boolean)hbStoreSession.getHibernateTxStatus());
        identitySession.getTransaction().commit();
        LazyTransactionTestCase.assertNull((Object)hbStoreSession.getHibernateTxStatus());
        LazyTransactionTestCase.assertFalse((boolean)identitySession.getTransaction().isActive());
        identitySession.beginTransaction();
        LazyTransactionTestCase.assertTrue((boolean)identitySession.getTransaction().isActive());
        LazyTransactionTestCase.assertFalse((boolean)hbStoreSession.getHibernateTxStatus());
        identitySession.getPersistenceManager().findGroup("someGroup");
        LazyTransactionTestCase.assertTrue((boolean)hbStoreSession.getHibernateTxStatus());
        identitySession.getTransaction().rollback();
        LazyTransactionTestCase.assertNull((Object)hbStoreSession.getHibernateTxStatus());
        LazyTransactionTestCase.assertFalse((boolean)identitySession.getTransaction().isActive());
        this.getHibernateSupport().rollbackTransaction();
    }

    @Override
    public void begin() {
    }

    @Override
    public void commit() {
    }
}

