/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.store.hibernate;

import org.picketlink.idm.api.IdentitySessionFactory;
import org.picketlink.idm.impl.api.APITestContext;
import org.picketlink.idm.impl.api.GroupQueryTest;
import org.picketlink.idm.impl.api.OrganizationTest;
import org.picketlink.idm.impl.api.PersistenceManagerTest;
import org.picketlink.idm.impl.api.RelationshipManagerTest;
import org.picketlink.idm.impl.api.RoleManagerTest;
import org.picketlink.idm.impl.api.RoleQueryTest;
import org.picketlink.idm.impl.api.UserQueryTest;
import org.picketlink.idm.impl.configuration.IdentityConfigurationImpl;
import org.picketlink.idm.test.support.hibernate.HibernateTestPOJO;

public class MinimalFlexibleConfigTestCase
extends HibernateTestPOJO
implements APITestContext {
    private OrganizationTest orgTest;
    private PersistenceManagerTest persistenceManagerTest;
    private RelationshipManagerTest relationshipManagerTest;
    private RoleManagerTest roleManagerTest;
    private UserQueryTest userQueryTest;
    private GroupQueryTest groupQueryTest;
    private RoleQueryTest roleQueryTest;
    protected IdentitySessionFactory identitySessionFactory;
    private String identityConfigLocation = "minimal-flexible-identity-config.xml";

    public void setUp() throws Exception {
        super.start();
        this.setIdentityConfig(this.identityConfigLocation);
        this.setRealmName("realm::FlexibleRealm");
        this.orgTest = new OrganizationTest((APITestContext)this);
        this.persistenceManagerTest = new PersistenceManagerTest((APITestContext)this);
        this.relationshipManagerTest = new RelationshipManagerTest((APITestContext)this);
        this.roleManagerTest = new RoleManagerTest((APITestContext)this);
        this.userQueryTest = new UserQueryTest((APITestContext)this);
        this.groupQueryTest = new GroupQueryTest((APITestContext)this);
        this.roleQueryTest = new RoleQueryTest((APITestContext)this);
        this.identitySessionFactory = new IdentityConfigurationImpl().configure(this.getIdentityConfig()).buildIdentitySessionFactory();
    }

    public void tearDown() throws Exception {
        super.stop();
    }

    public IdentitySessionFactory getIdentitySessionFactory() {
        return this.identitySessionFactory;
    }

    public void testOrganization() throws Exception {
        this.orgTest.testRedHatOrganization(this.getRealmName());
    }

    public void testSamplePortal() throws Exception {
        this.orgTest.testSamplePortal(this.getRealmName());
    }

    public void testPersistenceManager() throws Exception {
        this.persistenceManagerTest.testMethods(this.getRealmName());
    }

    public void testRelationshipManager() throws Exception {
        this.relationshipManagerTest.testMethods(this.getRealmName());
    }

    public void testRelationshipManagerCascade() throws Exception {
        this.relationshipManagerTest.testCascade(this.getRealmName());
    }

    public void testRelationshipManagerMergedRoleAssociations() throws Exception {
        this.relationshipManagerTest.testMergedRoleAssociations(this.getRealmName());
    }

    public void testRoleManager() throws Exception {
        this.roleManagerTest.testMethods(this.getRealmName());
    }

    public void testUserQuery() throws Exception {
        this.userQueryTest.testQuery(this.getRealmName());
    }

    public void testGroupQuery() throws Exception {
        this.groupQueryTest.testQuery(this.getRealmName());
    }

    public void testRoleQuery() throws Exception {
        this.roleQueryTest.testQuery(this.getRealmName());
    }

    protected void setIdentityConfigLocation(String identityConfigLocation) {
        this.identityConfigLocation = identityConfigLocation;
    }
}

