/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.authentication.web;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.picketlink.Identity;
import org.picketlink.authentication.web.BasicAuthenticationScheme;
import org.picketlink.authentication.web.DigestAuthenticationScheme;
import org.picketlink.authentication.web.HTTPAuthenticationScheme;
import org.picketlink.credential.DefaultLoginCredentials;

@ApplicationScoped
public class AuthenticationFilter
implements Filter {
    private static final String DEFAULT_REALM_NAME = "PicketLink Default Realm";
    @Inject
    private Instance<Identity> identityInstance;
    @Inject
    private Instance<DefaultLoginCredentials> credentialsInstance;
    private Map<AuthType, HTTPAuthenticationScheme> authenticationSchemes = new HashMap<AuthType, HTTPAuthenticationScheme>();
    private AuthType authType = AuthType.BASIC;
    private String realm = "PicketLink Default Realm";

    public void init(FilterConfig config) throws ServletException {
        String providedRealm = config.getInitParameter("realm");
        if (providedRealm != null) {
            this.realm = providedRealm;
        }
        this.setAuthType(config.getInitParameter("authType"));
        this.authenticationSchemes.put(AuthType.DIGEST, new DigestAuthenticationScheme(this.realm));
        this.authenticationSchemes.put(AuthType.BASIC, new BasicAuthenticationScheme(this.realm));
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        DefaultLoginCredentials creds;
        Identity identity;
        if (!HttpServletRequest.class.isInstance(servletRequest)) {
            throw new ServletException("This filter can only process HttpServletRequest requests.");
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        request.getSession();
        try {
            identity = (Identity)this.identityInstance.get();
        }
        catch (Exception e) {
            throw new ServletException("Identity not found - please ensure that the Identity component is created on startup.", (Throwable)e);
        }
        try {
            creds = (DefaultLoginCredentials)((Object)this.credentialsInstance.get());
        }
        catch (Exception e) {
            throw new ServletException("DefaultLoginCredentials not found - please ensure that the DefaultLoginCredentials component is created on startup.", (Throwable)e);
        }
        HTTPAuthenticationScheme authenticationScheme = this.authenticationSchemes.get((Object)this.authType);
        if (!identity.isLoggedIn()) {
            authenticationScheme.extractCredential(request, creds);
            if (creds.getCredential() != null) {
                identity.login();
            }
        }
        if (identity.isLoggedIn()) {
            chain.doFilter(servletRequest, servletResponse);
        } else {
            authenticationScheme.challengeClient(request, response);
        }
    }

    public void destroy() {
    }

    private void setAuthType(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Null authentication type provided.");
        }
        try {
            this.authType = AuthType.valueOf(value);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unsupported authentication type. Possible values are: BASIC and DIGEST.", e);
        }
    }

    public static enum AuthType {
        BASIC,
        DIGEST;

    }
}

