/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.authentication.web;

import java.io.IOException;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.picketlink.authentication.web.HTTPAuthenticationScheme;
import org.picketlink.common.util.Base64;
import org.picketlink.common.util.StringUtil;
import org.picketlink.credential.DefaultLoginCredentials;
import org.picketlink.idm.credential.Password;

public class BasicAuthenticationScheme
implements HTTPAuthenticationScheme {
    private String realm;
    @Inject
    Instance<DefaultLoginCredentials> credentials;

    public BasicAuthenticationScheme(String realm) {
        this.realm = realm;
    }

    @Override
    public void extractCredential(HttpServletRequest request, DefaultLoginCredentials creds) {
        if (this.isBasicAuthentication(request)) {
            String[] usernameAndPassword = this.extractUsernameAndPassword(request);
            String username = usernameAndPassword[0];
            String password = usernameAndPassword[1];
            if (!StringUtil.isNullOrEmpty((String)username) || !StringUtil.isNullOrEmpty((String)password)) {
                creds.setUserId(username);
                creds.setCredential(new Password(password.toCharArray()));
            }
        }
    }

    @Override
    public void challengeClient(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.addHeader("WWW-Authenticate", "Basic realm=\"" + this.realm + "\"");
        response.sendError(401, "Not authorized");
    }

    private boolean isBasicAuthentication(HttpServletRequest request) {
        return this.getAuthorizationHeader(request) != null && this.getAuthorizationHeader(request).startsWith("Basic ");
    }

    private String getAuthorizationHeader(HttpServletRequest request) {
        return request.getHeader("Authorization");
    }

    public String[] extractUsernameAndPassword(HttpServletRequest request) {
        String authorizationHeader = this.getAuthorizationHeader(request);
        String base64Token = authorizationHeader.substring(6);
        String token = new String(Base64.decode((String)base64Token));
        String username = "";
        String password = "";
        int delim = token.indexOf(":");
        if (delim != -1) {
            username = token.substring(0, delim);
            password = token.substring(delim + 1);
        }
        return new String[]{username, password};
    }
}

