/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.authentication.web;

import java.io.IOException;
import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.picketlink.authentication.web.HTTPAuthenticationScheme;
import org.picketlink.credential.DefaultLoginCredentials;
import org.picketlink.idm.credential.X509CertificateCredentials;

public class ClientCertAuthenticationScheme
implements HTTPAuthenticationScheme {
    public static final String X509_CLIENT_CERT_REQUEST_ATTRIBUTE = "javax.servlet.request.X509Certificate";

    @Override
    public void extractCredential(HttpServletRequest request, DefaultLoginCredentials creds) {
        X509Certificate[] clientCerts = this.getClientCertificate(request);
        if (clientCerts != null && clientCerts.length > 0) {
            X509CertificateCredentials credential = new X509CertificateCredentials(clientCerts[0]);
            credential.setTrusted(true);
            creds.setCredential(credential);
        }
    }

    @Override
    public void challengeClient(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendError(403, "The requested resource requires a valid certificate.");
    }

    @Override
    public boolean postAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return true;
    }

    private X509Certificate[] getClientCertificate(HttpServletRequest request) {
        return (X509Certificate[])request.getAttribute(X509_CLIENT_CERT_REQUEST_ATTRIBUTE);
    }
}

