/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.subsystem.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.dmr.ModelNode;
import org.picketlink.as.subsystem.model.ModelElement;

public class SubsystemDescriber {
    private static final Map<ModelElement, List<SimpleAttributeDefinition>> attributeDefinitions = new HashMap<ModelElement, List<SimpleAttributeDefinition>>();
    private static final Map<ModelElement, List<ResourceDefinition>> childResourceDefinitions = new HashMap<ModelElement, List<ResourceDefinition>>();

    public static void addAttributeDefinition(ModelElement resourceDefinitionKey, SimpleAttributeDefinition attribute) {
        List<SimpleAttributeDefinition> resourceAttributes = attributeDefinitions.get((Object)resourceDefinitionKey);
        if (resourceAttributes == null) {
            resourceAttributes = new ArrayList<SimpleAttributeDefinition>();
            attributeDefinitions.put(resourceDefinitionKey, resourceAttributes);
        }
        if (!resourceAttributes.contains(attribute)) {
            resourceAttributes.add(attribute);
        }
    }

    public static void addChildResourceDefinition(ModelElement resourceDefinitionKey, ResourceDefinition attribute) {
        List<ResourceDefinition> childResources = childResourceDefinitions.get((Object)resourceDefinitionKey);
        if (childResources == null) {
            childResources = new ArrayList<ResourceDefinition>();
            childResourceDefinitions.put(resourceDefinitionKey, childResources);
        }
        if (!childResources.contains(attribute)) {
            childResources.add(attribute);
        }
    }

    public static List<SimpleAttributeDefinition> getAttributeDefinition(ModelElement modelElement) {
        return attributeDefinitions.get((Object)modelElement);
    }

    public static List<ResourceDefinition> getChildResourceDefinitions(ModelElement parentModelElement) {
        return childResourceDefinitions.get((Object)parentModelElement);
    }

    public static final ModelNode getOperationDescription(String operationName, String description) {
        ModelNode root = new ModelNode();
        root.get("operation-name").set(operationName);
        root.get("description").set(description);
        root.get("reply-properties").setEmptyObject();
        return root;
    }
}

