/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.jboss.auth;

import java.security.Principal;
import java.security.acl.Group;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.xml.bind.JAXBElement;
import org.jboss.security.auth.spi.AbstractServerLoginModule;
import org.picketlink.identity.federation.bindings.jboss.subject.PicketLinkGroup;
import org.picketlink.identity.federation.bindings.jboss.subject.PicketLinkPrincipal;
import org.picketlink.identity.federation.core.wstrust.SAMLPrincipal;
import org.picketlink.identity.federation.core.wstrust.STSClient;
import org.picketlink.identity.federation.core.wstrust.STSClientConfig;
import org.picketlink.identity.federation.core.wstrust.SamlCredential;
import org.picketlink.identity.federation.core.wstrust.WSTrustException;
import org.picketlink.identity.federation.core.wstrust.plugins.saml.SAMLUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.assertion.StatementAbstractType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectType;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAML2STSIssuingLoginModule
extends AbstractServerLoginModule {
    private String endpointURL = null;
    private String portName = "PicketLinkSTSPort";
    private String serviceName = "PicketLinkSTS";
    private SAMLPrincipal principal;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        if (options.get("endpointAddress") == null) {
            throw new IllegalArgumentException("The endpointURL property is required and must specify the STS URL");
        }
        this.endpointURL = (String)options.get("endpointAddress");
        String option = (String)options.get("portName");
        if (option != null) {
            this.portName = option;
        }
        if ((option = (String)options.get("serviceName")) != null) {
            this.serviceName = option;
        }
    }

    public boolean login() throws LoginException {
        if (super.login()) {
            Object sharedPrincipal = this.sharedState.get("javax.security.auth.login.name");
            if (!(sharedPrincipal instanceof SAMLPrincipal)) {
                this.log.warn((Object)"Shared principal is not a SAMLPrincipal.");
                return false;
            }
            this.principal = (SAMLPrincipal)sharedPrincipal;
            return true;
        }
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available to collect authentication information");
        }
        NameCallback nc = new NameCallback("User name: ", "guest");
        PasswordCallback pc = new PasswordCallback("Password: ", false);
        Callback[] callbacks = new Callback[]{nc, pc};
        String username = null;
        String password = null;
        try {
            this.callbackHandler.handle(callbacks);
            username = nc.getName();
            password = new String(pc.getPassword());
        }
        catch (Exception e) {
            LoginException exception = new LoginException("Error handling callback" + e.getMessage());
            exception.initCause(e);
            throw exception;
        }
        STSClientConfig.Builder builder = new STSClientConfig.Builder();
        builder.endpointAddress(this.endpointURL).portName(this.portName).serviceName(this.serviceName);
        builder.username(username).password(password);
        STSClient client = new STSClient(builder.build());
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Calling STS at " + this.endpointURL));
            }
            Element assertionElement = client.issueToken("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
            SamlCredential credential = new SamlCredential(assertionElement);
            this.principal = new SAMLPrincipal(this.getAssertionSubjectName(assertionElement), credential);
        }
        catch (WSTrustException we) {
            LoginException exception = new LoginException("Failed to authenticate client via STS: " + we.getMessage());
            exception.initCause(we);
            throw exception;
        }
        if (super.getUseFirstPass()) {
            this.sharedState.put("javax.security.auth.login.name", this.principal);
            this.sharedState.put("javax.security.auth.login.password", this.principal.getSAMLCredential());
        }
        this.loginOk = true;
        return true;
    }

    protected Principal getIdentity() {
        return this.principal;
    }

    protected Group[] getRoleSets() throws LoginException {
        PicketLinkGroup callerPrincipal = new PicketLinkGroup("CallerPrincipal");
        callerPrincipal.addMember((Principal)this.principal);
        try {
            AssertionType assertion = SAMLUtil.fromElement((Element)this.principal.getSAMLCredential().getAssertionAsElement());
            AttributeStatementType attributeStatement = this.getAttributeStatement(assertion);
            if (attributeStatement != null) {
                HashSet<PicketLinkPrincipal> roles = new HashSet<PicketLinkPrincipal>();
                List attributeList = attributeStatement.getAttributeOrEncryptedAttribute();
                for (Object obj : attributeList) {
                    AttributeType attributeType;
                    if (!(obj instanceof AttributeType) || !(attributeType = (AttributeType)obj).getName().equals("role")) continue;
                    for (Object value : attributeType.getAttributeValue()) {
                        roles.add(new PicketLinkPrincipal((String)value));
                    }
                }
                PicketLinkGroup rolesGroup = new PicketLinkGroup("Roles");
                for (Principal principal : roles) {
                    rolesGroup.addMember(principal);
                }
                return new Group[]{callerPrincipal, rolesGroup};
            }
        }
        catch (Exception e) {
            LoginException le = new LoginException("Failed to parse assertion element: " + e.getMessage());
            le.initCause(e);
            throw le;
        }
        return new Group[]{callerPrincipal};
    }

    private String getAssertionSubjectName(Element assertionElement) {
        try {
            AssertionType assertion = SAMLUtil.fromElement((Element)assertionElement);
            SubjectType subject = assertion.getSubject();
            if (subject != null) {
                for (JAXBElement element : subject.getContent()) {
                    if (!element.getDeclaredType().equals(NameIDType.class)) continue;
                    NameIDType nameID = (NameIDType)element.getValue();
                    return nameID.getValue();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse assertion element" + e.getMessage(), e);
        }
        return null;
    }

    private AttributeStatementType getAttributeStatement(AssertionType assertion) {
        List statementList = assertion.getStatementOrAuthnStatementOrAuthzDecisionStatement();
        if (statementList.size() != 0) {
            for (StatementAbstractType statement : statementList) {
                if (!(statement instanceof AttributeStatementType)) continue;
                return (AttributeStatementType)statement;
            }
        }
        return null;
    }
}

