/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.jboss.auth;

import java.security.Principal;
import java.security.acl.Group;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.xml.bind.JAXBElement;
import org.jboss.security.auth.callback.ObjectCallback;
import org.jboss.security.auth.spi.AbstractServerLoginModule;
import org.picketlink.identity.federation.bindings.jboss.subject.PicketLinkGroup;
import org.picketlink.identity.federation.bindings.jboss.subject.PicketLinkPrincipal;
import org.picketlink.identity.federation.core.wstrust.STSClient;
import org.picketlink.identity.federation.core.wstrust.STSClientConfig;
import org.picketlink.identity.federation.core.wstrust.SamlCredential;
import org.picketlink.identity.federation.core.wstrust.WSTrustException;
import org.picketlink.identity.federation.core.wstrust.plugins.saml.SAMLUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.assertion.StatementAbstractType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectType;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAML2STSLoginModule
extends AbstractServerLoginModule {
    private String stsConfigurationFile;
    private Principal principal;
    private SamlCredential credential;
    private AssertionType assertion;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.stsConfigurationFile = (String)options.get("configFile");
    }

    public boolean login() throws LoginException {
        block17: {
            if (super.login()) {
                Object sharedPrincipal = this.sharedState.get("javax.security.auth.login.name");
                if (sharedPrincipal instanceof Principal) {
                    this.principal = (Principal)sharedPrincipal;
                } else {
                    try {
                        this.principal = this.createIdentity(sharedPrincipal.toString());
                    }
                    catch (Exception e) {
                        throw new LoginException("Failed to create principal: " + e.getMessage());
                    }
                }
                Object credential = this.sharedState.get("javax.security.auth.login.password");
                if (!(credential instanceof SamlCredential)) {
                    throw new LoginException("Shared credential is not a SAML credential");
                }
                this.credential = (SamlCredential)credential;
                return true;
            }
            if (this.stsConfigurationFile == null) {
                throw new LoginException("Failed to validate assertion: STS configuration file not specified");
            }
            ObjectCallback callback = new ObjectCallback(null);
            Element assertionElement = null;
            try {
                this.callbackHandler.handle(new Callback[]{callback});
                if (!(callback.getCredential() instanceof SamlCredential)) {
                    throw new LoginException("Supplied credential is not a SAML credential");
                }
                this.credential = (SamlCredential)callback.getCredential();
                assertionElement = this.credential.getAssertionAsElement();
            }
            catch (Exception e) {
                LoginException exception = new LoginException("Error handling callback" + e.getMessage());
                exception.initCause(e);
                throw exception;
            }
            STSClientConfig.Builder builder = new STSClientConfig.Builder(this.stsConfigurationFile);
            STSClient client = new STSClient(builder.build());
            try {
                boolean isValid = client.validateToken(assertionElement);
                if (!isValid) {
                    throw new LoginException("Supplied assertion was considered invalid by the STS");
                }
            }
            catch (WSTrustException we) {
                LoginException exception = new LoginException("Failed to validate assertion using STS: " + we.getMessage());
                exception.initCause(we);
                throw exception;
            }
            try {
                this.assertion = SAMLUtil.fromElement((Element)assertionElement);
                SubjectType subject = this.assertion.getSubject();
                if (subject == null) break block17;
                for (JAXBElement element : subject.getContent()) {
                    if (!element.getDeclaredType().equals(NameIDType.class)) continue;
                    NameIDType nameID = (NameIDType)element.getValue();
                    this.principal = new PicketLinkPrincipal(nameID.getValue());
                    break;
                }
            }
            catch (Exception e) {
                LoginException exception = new LoginException("Failed to parse assertion element" + e.getMessage());
                exception.initCause(e);
                throw exception;
            }
        }
        if (this.getUseFirstPass()) {
            this.sharedState.put("javax.security.auth.login.name", this.principal);
            this.sharedState.put("javax.security.auth.login.password", this.credential);
        }
        this.loginOk = true;
        return true;
    }

    protected Principal getIdentity() {
        return this.principal;
    }

    protected Group[] getRoleSets() throws LoginException {
        AttributeStatementType attributeStatement;
        if (this.assertion == null) {
            try {
                this.assertion = SAMLUtil.fromElement((Element)this.credential.getAssertionAsElement());
            }
            catch (Exception e) {
                LoginException le = new LoginException("Failed to parse assertion element: " + e.getMessage());
                le.initCause(e);
                throw le;
            }
        }
        if ((attributeStatement = this.getAttributeStatement(this.assertion)) != null) {
            HashSet<PicketLinkPrincipal> roles = new HashSet<PicketLinkPrincipal>();
            List attributeList = attributeStatement.getAttributeOrEncryptedAttribute();
            for (Object obj : attributeList) {
                AttributeType attributeType;
                if (!(obj instanceof AttributeType) || !(attributeType = (AttributeType)obj).getName().equals("role")) continue;
                for (Object value : attributeType.getAttributeValue()) {
                    roles.add(new PicketLinkPrincipal((String)value));
                }
            }
            PicketLinkGroup rolesGroup = new PicketLinkGroup("Roles");
            for (Principal principal : roles) {
                rolesGroup.addMember(principal);
            }
            return new Group[]{rolesGroup};
        }
        return new Group[0];
    }

    private AttributeStatementType getAttributeStatement(AssertionType assertion) {
        List statementList = assertion.getStatementOrAuthnStatementOrAuthzDecisionStatement();
        if (statementList.size() != 0) {
            for (StatementAbstractType statement : statementList) {
                if (!(statement instanceof AttributeStatementType)) continue;
                return (AttributeStatementType)statement;
            }
        }
        return null;
    }
}

