/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.api.saml.v2.metadata;

import java.math.BigInteger;
import org.picketlink.identity.federation.api.saml.v2.metadata.MetaDataBuilder;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.saml.v2.metadata.KeyDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.KeyTypes;
import org.picketlink.identity.federation.saml.v2.metadata.ObjectFactory;
import org.picketlink.identity.xmlsec.w3.xmldsig.KeyInfoType;
import org.picketlink.identity.xmlsec.w3.xmlenc.EncryptionMethodType;

public class KeyDescriptorMetaDataBuilder {
    public static KeyDescriptorType createKeyDescriptor(KeyInfoType keyInfo, String algorithm, int keySize, boolean isSigningKey, boolean isEncryptionKey) {
        if (keyInfo == null) {
            throw new IllegalArgumentException("keyInfo is null");
        }
        if (isSigningKey == isEncryptionKey) {
            throw new IllegalArgumentException("Only one of isSigningKey and isEncryptionKey should be true");
        }
        KeyDescriptorType keyDescriptor = KeyDescriptorMetaDataBuilder.getObjectFactory().createKeyDescriptorType();
        if (StringUtil.isNotNull(algorithm)) {
            EncryptionMethodType encryptionMethod = new EncryptionMethodType();
            encryptionMethod.setAlgorithm(algorithm);
            encryptionMethod.getContent().add(BigInteger.valueOf(keySize));
            keyDescriptor.getEncryptionMethod().add(encryptionMethod);
        }
        if (isSigningKey) {
            keyDescriptor.setUse(KeyTypes.SIGNING);
        }
        if (isEncryptionKey) {
            keyDescriptor.setUse(KeyTypes.ENCRYPTION);
        }
        keyDescriptor.setKeyInfo(keyInfo);
        return keyDescriptor;
    }

    public static ObjectFactory getObjectFactory() {
        return MetaDataBuilder.getObjectFactory();
    }
}

