/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.util;

import java.security.PublicKey;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.core.config.KeyProviderType;
import org.picketlink.identity.federation.core.config.ProviderType;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.interfaces.TrustKeyManager;
import org.picketlink.identity.federation.core.util.SecurityActions;

public class CoreConfigUtil {
    private static Logger log = Logger.getLogger(CoreConfigUtil.class);

    public static TrustKeyManager getTrustKeyManager(ProviderType idpOrSPConfiguration) {
        KeyProviderType keyProvider = idpOrSPConfiguration.getKeyProvider();
        return CoreConfigUtil.getTrustKeyManager(keyProvider);
    }

    public static TrustKeyManager getTrustKeyManager(KeyProviderType keyProvider) {
        TrustKeyManager trustKeyManager = null;
        try {
            ClassLoader tcl = SecurityActions.getContextClassLoader();
            String keyManagerClassName = keyProvider.getClassName();
            if (keyManagerClassName == null) {
                throw new RuntimeException("KeyManager class name is null");
            }
            Class<?> clazz = tcl.loadClass(keyManagerClassName);
            trustKeyManager = (TrustKeyManager)clazz.newInstance();
        }
        catch (Exception e) {
            log.error((Object)"Exception in getting TrustKeyManager:", (Throwable)e);
        }
        return trustKeyManager;
    }

    public static PublicKey getValidatingKey(ProviderType idpSpConfiguration, String domain) throws ConfigurationException, ProcessingException {
        TrustKeyManager trustKeyManager = CoreConfigUtil.getTrustKeyManager(idpSpConfiguration);
        return CoreConfigUtil.getValidatingKey(trustKeyManager, domain);
    }

    public static PublicKey getValidatingKey(TrustKeyManager trustKeyManager, String domain) throws ConfigurationException, ProcessingException {
        if (trustKeyManager == null) {
            throw new IllegalArgumentException("Trust Key Manager is null");
        }
        return trustKeyManager.getValidatingKey(domain);
    }
}

