/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust;

import java.io.InputStream;
import java.net.URL;
import javax.annotation.Resource;
import javax.xml.bind.JAXBElement;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceProvider;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.core.config.STSType;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.saml.v2.common.SAMLDocumentHolder;
import org.picketlink.identity.federation.core.util.JAXBUtil;
import org.picketlink.identity.federation.core.wstrust.PicketLinkSTSConfiguration;
import org.picketlink.identity.federation.core.wstrust.STSConfiguration;
import org.picketlink.identity.federation.core.wstrust.SecurityActions;
import org.picketlink.identity.federation.core.wstrust.SecurityTokenService;
import org.picketlink.identity.federation.core.wstrust.WSTrustException;
import org.picketlink.identity.federation.core.wstrust.WSTrustJAXBFactory;
import org.picketlink.identity.federation.core.wstrust.WSTrustRequestHandler;
import org.picketlink.identity.federation.core.wstrust.wrappers.BaseRequestSecurityToken;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityToken;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityTokenCollection;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityTokenResponse;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityTokenResponseCollection;
import org.w3c.dom.Document;

@WebServiceProvider(serviceName="PicketLinkSTS", portName="PicketLinkSTSPort", targetNamespace="urn:picketlink:identity-federation:sts", wsdlLocation="WEB-INF/wsdl/PicketLinkSTS.wsdl")
@ServiceMode(value=Service.Mode.PAYLOAD)
public class PicketLinkSTS
implements SecurityTokenService {
    private static Logger logger = Logger.getLogger(PicketLinkSTS.class);
    public static final String STS_CONFIG_FILE = "picketlink-sts.xml";
    @Resource
    protected WebServiceContext context;
    protected STSConfiguration config;

    public Source invoke(Source request) {
        BaseRequestSecurityToken baseRequest;
        try {
            baseRequest = WSTrustJAXBFactory.getInstance().parseRequestSecurityToken(request);
        }
        catch (ParsingException e) {
            throw new RuntimeException(e);
        }
        if (baseRequest instanceof RequestSecurityToken) {
            return this.handleTokenRequest((RequestSecurityToken)baseRequest);
        }
        if (baseRequest instanceof RequestSecurityTokenCollection) {
            return this.handleTokenRequestCollection((RequestSecurityTokenCollection)baseRequest);
        }
        throw new WebServiceException("Invalid security token request");
    }

    protected Source handleTokenRequest(RequestSecurityToken request) {
        SAMLDocumentHolder holder = WSTrustJAXBFactory.getInstance().getSAMLDocumentHolderOnThread();
        request.setRSTDocument(holder.getSamlDocument());
        if (this.config == null) {
            try {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"Loading STS configuration");
                }
                this.config = this.getConfiguration();
            }
            catch (ConfigurationException e) {
                throw new WebServiceException("Encountered configuration exception:", (Throwable)e);
            }
        }
        WSTrustRequestHandler handler = this.config.getRequestHandler();
        String requestType = request.getRequestType().toString();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("STS received request of type " + requestType));
        }
        try {
            if (requestType.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Issue")) {
                Source source = this.marshallResponse(handler.issue(request, this.context.getUserPrincipal()));
                Document doc = handler.postProcess((Document)((DOMSource)source).getNode(), request);
                return new DOMSource(doc);
            }
            if (requestType.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Renew")) {
                Source source = this.marshallResponse(handler.renew(request, this.context.getUserPrincipal()));
                Document document = handler.postProcess((Document)((DOMSource)source).getNode(), request);
                return new DOMSource(document);
            }
            if (requestType.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Cancel")) {
                return this.marshallResponse(handler.cancel(request, this.context.getUserPrincipal()));
            }
            if (requestType.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Validate")) {
                return this.marshallResponse(handler.validate(request, this.context.getUserPrincipal()));
            }
            throw new WSTrustException("Invalid request type: " + requestType);
        }
        catch (WSTrustException we) {
            throw new WebServiceException("Exception in handling token request:", (Throwable)we);
        }
    }

    protected Source handleTokenRequestCollection(RequestSecurityTokenCollection requestCollection) {
        throw new UnsupportedOperationException();
    }

    protected Source marshallResponse(RequestSecurityTokenResponse response) {
        RequestSecurityTokenResponseCollection responseCollection = new RequestSecurityTokenResponseCollection();
        responseCollection.addRequestSecurityTokenResponse(response);
        return WSTrustJAXBFactory.getInstance().marshallRequestSecurityTokenResponse(responseCollection);
    }

    protected STSConfiguration getConfiguration() throws ConfigurationException {
        URL configurationFile = SecurityActions.getContextClassLoader().getResource(STS_CONFIG_FILE);
        if (configurationFile == null) {
            logger.warn((Object)"picketlink-sts.xml configuration file not found. Using default configuration values");
            return new PicketLinkSTSConfiguration();
        }
        try {
            String pkgName = "org.picketlink.identity.federation.core.config";
            InputStream stream = configurationFile.openStream();
            JAXBElement element = (JAXBElement)JAXBUtil.getUnmarshaller(pkgName).unmarshal(stream);
            STSType stsConfig = (STSType)element.getValue();
            PicketLinkSTSConfiguration configuration = new PicketLinkSTSConfiguration(stsConfig);
            if (logger.isInfoEnabled()) {
                logger.info((Object)"picketlink-sts.xml configuration file loaded");
            }
            return configuration;
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing the configuration file:", e);
        }
    }
}

