/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.discovery;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.Identifier;
import org.openid4java.discovery.UrlIdentifier;
import org.openid4java.discovery.XriIdentifier;
import org.openid4java.discovery.html.HtmlResolver;
import org.openid4java.discovery.xri.XriResolver;
import org.openid4java.discovery.yadis.YadisResolver;
import org.openid4java.util.HttpCache;
import org.openid4java.util.OpenID4JavaUtils;

public class Discovery {
    private static Log _log = LogFactory.getLog(Discovery.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    private static final Pattern URL_PATTERN = Pattern.compile("^https?://", 2);
    private static final Pattern XRI_PATTERN = Pattern.compile("^[!=@\\$\\+\\(]", 2);
    private static HtmlResolver _htmlResolver = new HtmlResolver();
    private static YadisResolver _yadisResolver = new YadisResolver();
    private static XriResolver _xriResolver;
    private static final String XRI_RESOLVER_CLASS_NAME_KEY = "discovery.xri.resolver";

    public void setXriResolver(XriResolver xriResolver) {
        _xriResolver = xriResolver;
    }

    public void setYadisResolver(YadisResolver yadisResolver) {
        _yadisResolver = yadisResolver;
    }

    public void setHtmlResolver(HtmlResolver htmlResolver) {
        _htmlResolver = htmlResolver;
    }

    public Identifier parseIdentifier(String identifier) throws DiscoveryException {
        return this.parseIdentifier(identifier, false);
    }

    public Identifier parseIdentifier(String identifier, boolean removeFragment) throws DiscoveryException {
        try {
            if (identifier.toLowerCase().startsWith("xri://")) {
                if (DEBUG) {
                    _log.debug((Object)("Dropping xri:// prefix from identifier: " + identifier));
                }
                identifier = identifier.substring(6);
            }
            if (URL_PATTERN.matcher(identifier).find()) {
                if (DEBUG) {
                    _log.debug((Object)("Creating URL identifier for: " + identifier));
                }
                return new UrlIdentifier(identifier, removeFragment);
            }
            if (XRI_PATTERN.matcher(identifier).find()) {
                if (DEBUG) {
                    _log.debug((Object)("Creating XRI identifier for: " + identifier));
                }
                return _xriResolver.parseIdentifier(identifier);
            }
            if (DEBUG) {
                _log.debug((Object)("Creating URL identifier (http:// prepended) for: " + identifier));
            }
            return new UrlIdentifier("http://" + identifier, removeFragment);
        }
        catch (Exception e) {
            throw new DiscoveryException("Cannot parse identifier: " + identifier, (Throwable)e);
        }
    }

    public List discover(String identifier) throws DiscoveryException {
        return this.discover(this.parseIdentifier(identifier, true));
    }

    public List discover(Identifier identifier) throws DiscoveryException {
        List result;
        if (identifier instanceof XriIdentifier) {
            _log.info((Object)("Starting discovery on XRI identifier: " + identifier));
            result = _xriResolver.discover((XriIdentifier)identifier);
        } else if (identifier instanceof UrlIdentifier) {
            _log.info((Object)("Starting discovery on URL identifier: " + identifier));
            UrlIdentifier urlId = (UrlIdentifier)identifier;
            HttpCache cache = new HttpCache();
            result = _yadisResolver.discover(urlId.getIdentifier(), cache);
            if (result == null || result.size() == 0) {
                _log.info((Object)"No OpenID service endpoints discovered through Yadis; attempting HTML discovery...");
                result = _htmlResolver.discoverHtml(urlId, cache);
            }
        } else {
            throw new DiscoveryException("Unknown identifier type: " + identifier.toString());
        }
        _log.info((Object)("Discovered " + result.size() + " OpenID endpoints."));
        return result;
    }

    public static List rpDiscovery(String realm, YadisResolver yadisResolver) throws DiscoveryException {
        return yadisResolver.discoverRP(realm);
    }

    static {
        String className = OpenID4JavaUtils.getProperty(XRI_RESOLVER_CLASS_NAME_KEY);
        if (DEBUG) {
            _log.debug((Object)("discovery.xri.resolver:" + className));
        }
        try {
            _xriResolver = (XriResolver)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializing XRI resolver.", e);
        }
    }
}

