/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.v2.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.core.saml.v2.constants.X500SAMLProfileConstants;
import org.picketlink.identity.federation.core.saml.v2.factories.JBossSAMLBaseFactory;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeType;
import org.picketlink.identity.federation.saml.v2.assertion.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementUtil {
    public static final QName X500_QNAME = new QName(JBossSAMLURIConstants.X500_NSURI.get(), "Encoding");
    private static ObjectFactory factory = new ObjectFactory();

    public static AttributeStatementType createAttributeStatement(Map<String, Object> attributes) {
        AttributeStatementType attrStatement = null;
        int i = 0;
        Set<String> keys = attributes.keySet();
        for (String key : keys) {
            if (i == 0) {
                attrStatement = JBossSAMLBaseFactory.createAttributeStatement();
                ++i;
            }
            if ("roles".equalsIgnoreCase(key)) {
                Object value = attributes.get(key);
                if (!(value instanceof Collection)) continue;
                Collection roles = (Collection)value;
                for (Object role : roles) {
                    AttributeType roleAttr = JBossSAMLBaseFactory.createAttributeForRole((String)role);
                    attrStatement.getAttributeOrEncryptedAttribute().add(factory.createAttribute(roleAttr));
                }
                continue;
            }
            AttributeType att = StatementUtil.getX500Attribute();
            Object value = attributes.get(key);
            if ("email".equals(key)) {
                att.setFriendlyName(X500SAMLProfileConstants.EMAIL_ADDRESS.getFriendlyName());
                att.setName(X500SAMLProfileConstants.EMAIL_ADDRESS.get());
            } else if ("employeeNumber".equals(key)) {
                att.setFriendlyName(X500SAMLProfileConstants.EMPLOYEE_NUMBER.getFriendlyName());
                att.setName(X500SAMLProfileConstants.EMPLOYEE_NUMBER.get());
            } else if ("givenName".equals(key)) {
                att.setFriendlyName(X500SAMLProfileConstants.GIVENNAME.getFriendlyName());
                att.setName(X500SAMLProfileConstants.GIVENNAME.get());
            } else if ("telephoneNumber".equals(key)) {
                att.setFriendlyName(X500SAMLProfileConstants.TELEPHONE.getFriendlyName());
                att.setName(X500SAMLProfileConstants.TELEPHONE.get());
            }
            att.getAttributeValue().add(value);
            attrStatement.getAttributeOrEncryptedAttribute().add(att);
        }
        return attrStatement;
    }

    public static AttributeStatementType createAttributeStatement(List<String> roles) {
        AttributeStatementType attrStatement = JBossSAMLBaseFactory.createAttributeStatement();
        for (String role : roles) {
            AttributeType attr = JBossSAMLBaseFactory.createAttributeForRole(role);
            attrStatement.getAttributeOrEncryptedAttribute().add(attr);
        }
        return attrStatement;
    }

    private static AttributeType getX500Attribute() {
        AttributeType att = factory.createAttributeType();
        att.getOtherAttributes().put(X500_QNAME, "LDAP");
        att.setNameFormat(JBossSAMLURIConstants.ATTRIBUTE_FORMAT_URI.get());
        return att;
    }
}

