/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.util;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.core.util.IDFedLSInputResolver;
import org.picketlink.identity.federation.core.util.SecurityActions;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBUtil {
    private static Logger log = Logger.getLogger(JAXBUtil.class);
    private static boolean trace = log.isTraceEnabled();
    public static final String W3C_XML_SCHEMA_NS_URI = "http://www.w3.org/2001/XMLSchema";
    private static HashMap<String, JAXBContext> jaxbContextHash = new HashMap();

    public static Marshaller getValidatingMarshaller(String pkgName, String schemaLocation) throws JAXBException, SAXException {
        Marshaller marshaller = JAXBUtil.getMarshaller(pkgName);
        Schema schema = JAXBUtil.getJAXPSchemaInstance(schemaLocation);
        marshaller.setSchema(schema);
        return marshaller;
    }

    public static Marshaller getMarshaller(String pkgName) throws JAXBException {
        if (pkgName == null) {
            throw new IllegalArgumentException("pkgName is null");
        }
        JAXBContext jc = JAXBUtil.getJAXBContext(pkgName);
        Marshaller marshaller = jc.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.FALSE);
        return marshaller;
    }

    public static Unmarshaller getUnmarshaller(String pkgName) throws JAXBException {
        if (pkgName == null) {
            throw new IllegalArgumentException("pkgName is null");
        }
        JAXBContext jc = JAXBUtil.getJAXBContext(pkgName);
        return jc.createUnmarshaller();
    }

    public static Unmarshaller getUnmarshaller(String ... pkgNames) throws JAXBException {
        if (pkgNames == null) {
            throw new IllegalArgumentException("pkgName is null");
        }
        int len = pkgNames.length;
        if (len == 0) {
            return JAXBUtil.getUnmarshaller(pkgNames[0]);
        }
        JAXBContext jc = JAXBUtil.getJAXBContext(pkgNames);
        return jc.createUnmarshaller();
    }

    public static Unmarshaller getValidatingUnmarshaller(String pkgName, String schemaLocation) throws JAXBException, SAXException {
        Unmarshaller unmarshaller = JAXBUtil.getUnmarshaller(pkgName);
        Schema schema = JAXBUtil.getJAXPSchemaInstance(schemaLocation);
        unmarshaller.setSchema(schema);
        return unmarshaller;
    }

    public static Unmarshaller getValidatingUnmarshaller(String[] pkgNames, String[] schemaLocations) throws JAXBException, SAXException, IOException {
        StringBuilder builder = new StringBuilder();
        int len = pkgNames.length;
        if (len == 0) {
            throw new IllegalArgumentException("Packages are empty");
        }
        for (String pkg : pkgNames) {
            builder.append(pkg);
            builder.append(":");
        }
        Unmarshaller unmarshaller = JAXBUtil.getUnmarshaller(builder.toString());
        SchemaFactory schemaFactory = JAXBUtil.getSchemaFactory();
        Source[] schemaSources = new Source[schemaLocations.length];
        ClassLoader tcl = SecurityActions.getContextClassLoader();
        int i = 0;
        for (String schemaLocation : schemaLocations) {
            URL schemaURL = tcl.getResource(schemaLocation);
            if (schemaURL == null) {
                throw new IllegalStateException("Schema URL is null:" + schemaLocation);
            }
            schemaSources[i++] = new StreamSource(schemaURL.openStream());
        }
        Schema schema = schemaFactory.newSchema(schemaSources);
        unmarshaller.setSchema(schema);
        return unmarshaller;
    }

    private static Schema getJAXPSchemaInstance(String schemaLocation) throws SAXException {
        ClassLoader tcl = SecurityActions.getContextClassLoader();
        URL schemaURL = tcl.getResource(schemaLocation);
        if (schemaURL == null) {
            throw new IllegalStateException("Schema URL is null:" + schemaLocation);
        }
        SchemaFactory scFact = JAXBUtil.getSchemaFactory();
        Schema schema = scFact.newSchema(schemaURL);
        return schema;
    }

    private static SchemaFactory getSchemaFactory() {
        SchemaFactory scFact = SchemaFactory.newInstance(W3C_XML_SCHEMA_NS_URI);
        if (SecurityActions.getSystemProperty("org.picketlink.identity.federation.jaxb.ls", null) == null) {
            scFact.setResourceResolver(new IDFedLSInputResolver());
        }
        scFact.setErrorHandler(new ErrorHandler(){

            public void error(SAXParseException exception) throws SAXException {
                StringBuilder builder = new StringBuilder();
                builder.append("Line Number=").append(exception.getLineNumber());
                builder.append(" Col Number=").append(exception.getColumnNumber());
                builder.append(" Public ID=").append(exception.getPublicId());
                builder.append(" System ID=").append(exception.getSystemId());
                builder.append(" exc=").append(exception.getLocalizedMessage());
                if (trace) {
                    log.trace((Object)("SAX Error:" + builder.toString()));
                }
            }

            public void fatalError(SAXParseException exception) throws SAXException {
                StringBuilder builder = new StringBuilder();
                builder.append("Line Number=").append(exception.getLineNumber());
                builder.append(" Col Number=").append(exception.getColumnNumber());
                builder.append(" Public ID=").append(exception.getPublicId());
                builder.append(" System ID=").append(exception.getSystemId());
                builder.append(" exc=").append(exception.getLocalizedMessage());
                log.error((Object)("SAX Fatal Error:" + builder.toString()));
            }

            public void warning(SAXParseException exception) throws SAXException {
                StringBuilder builder = new StringBuilder();
                builder.append("Line Number=").append(exception.getLineNumber());
                builder.append(" Col Number=").append(exception.getColumnNumber());
                builder.append(" Public ID=").append(exception.getPublicId());
                builder.append(" System ID=").append(exception.getSystemId());
                builder.append(" exc=").append(exception.getLocalizedMessage());
                if (trace) {
                    log.trace((Object)("SAX Warn:" + builder.toString()));
                }
            }
        });
        return scFact;
    }

    public static JAXBContext getJAXBContext(String path) throws JAXBException {
        JAXBContext jx = jaxbContextHash.get(path);
        if (jx == null) {
            jx = JAXBContext.newInstance((String)path);
            jaxbContextHash.put(path, jx);
        }
        return jx;
    }

    public static JAXBContext getJAXBContext(String ... paths) throws JAXBException {
        int len = paths.length;
        if (len == 0) {
            return JAXBUtil.getJAXBContext(paths[0]);
        }
        StringBuilder builder = new StringBuilder();
        for (String path : paths) {
            builder.append(path).append(":");
        }
        String finalPath = builder.toString();
        JAXBContext jx = jaxbContextHash.get(finalPath);
        if (jx == null) {
            jx = JAXBContext.newInstance((String)finalPath);
            jaxbContextHash.put(finalPath, jx);
        }
        return jx;
    }

    public static JAXBContext getJAXBContext(Class<?> clazz) throws JAXBException {
        String clazzName = clazz.getName();
        JAXBContext jx = jaxbContextHash.get(clazzName);
        if (jx == null) {
            jx = JAXBContext.newInstance((Class[])new Class[]{clazz});
            jaxbContextHash.put(clazzName, jx);
        }
        return jx;
    }

    static {
        SecurityActions.setSystemProperty("com.sun.xml.bind.v2.runtime.JAXBContextImpl.fastBoot", "true");
    }
}

