/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust;

import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.wstrust.STSClientConfig;
import org.picketlink.identity.federation.core.wstrust.WSTrustException;
import org.picketlink.identity.federation.core.wstrust.WSTrustJAXBFactory;
import org.picketlink.identity.federation.core.wstrust.WSTrustUtil;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityToken;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityTokenCollection;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityTokenResponse;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityTokenResponseCollection;
import org.picketlink.identity.federation.ws.trust.CancelTargetType;
import org.picketlink.identity.federation.ws.trust.RenewTargetType;
import org.picketlink.identity.federation.ws.trust.StatusType;
import org.picketlink.identity.federation.ws.trust.ValidateTargetType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STSClient {
    private ThreadLocal<Dispatch<Source>> dispatchLocal = new InheritableThreadLocal<Dispatch<Source>>();
    private String targetNS = "http://org.picketlink.trust/sts/";

    public STSClient(STSClientConfig config) {
        QName service = new QName(this.targetNS, config.getServiceName());
        QName portName = new QName(this.targetNS, config.getPortName());
        Service jaxwsService = Service.create((QName)service);
        jaxwsService.addPort(portName, "http://schemas.xmlsoap.org/wsdl/soap/http", config.getEndPointAddress());
        Dispatch dispatch = jaxwsService.createDispatch(portName, Source.class, Service.Mode.PAYLOAD);
        Map reqContext = dispatch.getRequestContext();
        String username = config.getUsername();
        if (username != null) {
            reqContext.put("javax.xml.ws.security.auth.username", config.getUsername());
            reqContext.put("javax.xml.ws.security.auth.password", config.getPassword());
        }
        this.dispatchLocal.set((Dispatch<Source>)dispatch);
    }

    public Element issueToken(String tokenType) throws WSTrustException {
        RequestSecurityToken request = new RequestSecurityToken();
        this.setTokenType(tokenType, request);
        return this.issueToken(request);
    }

    public Element issueTokenForEndpoint(String endpointURI) throws WSTrustException {
        RequestSecurityToken request = new RequestSecurityToken();
        this.setAppliesTo(endpointURI, request);
        return this.issueToken(request);
    }

    public Element issueToken(String endpointURI, String tokenType) throws WSTrustException {
        if (endpointURI == null && tokenType == null) {
            throw new IllegalArgumentException("One of endpointURI or tokenType must be provided.");
        }
        RequestSecurityToken request = new RequestSecurityToken();
        this.setAppliesTo(endpointURI, request);
        this.setTokenType(tokenType, request);
        return this.issueToken(request);
    }

    public Element issueTokenOnBehalfOf(String endpointURI, String tokenType, Principal principal) throws WSTrustException {
        if (endpointURI == null && tokenType == null) {
            throw new IllegalArgumentException("One of endpointURI or tokenType must be provided.");
        }
        RequestSecurityToken request = new RequestSecurityToken();
        this.setAppliesTo(endpointURI, request);
        this.setTokenType(tokenType, request);
        this.setOnBehalfOf(principal, request);
        return this.issueToken(request);
    }

    private RequestSecurityToken setAppliesTo(String endpointURI, RequestSecurityToken rst) {
        if (endpointURI != null) {
            rst.setAppliesTo(WSTrustUtil.createAppliesTo(endpointURI));
        }
        return rst;
    }

    private RequestSecurityToken setTokenType(String tokenType, RequestSecurityToken rst) {
        if (tokenType != null) {
            rst.setTokenType(URI.create(tokenType));
        }
        return rst;
    }

    private RequestSecurityToken setOnBehalfOf(Principal principal, RequestSecurityToken request) {
        if (principal != null) {
            request.setOnBehalfOf(WSTrustUtil.createOnBehalfOfWithUsername(principal.getName(), null));
        }
        return request;
    }

    public Element issueToken(RequestSecurityToken request) throws WSTrustException {
        request.setRequestType(URI.create("http://docs.oasis-open.org/ws-sx/ws-trust/200512/BatchIssue"));
        RequestSecurityTokenCollection requestCollection = new RequestSecurityTokenCollection();
        requestCollection.addRequestSecurityToken(request);
        return this.issueTokens(requestCollection).get(0);
    }

    public List<Element> issueTokens(RequestSecurityTokenCollection requestCollection) throws WSTrustException {
        NodeList nodes;
        for (RequestSecurityToken request : requestCollection.getRequestSecurityTokens()) {
            if (request.getRequestType() == null) {
                request.setRequestType(URI.create("http://docs.oasis-open.org/ws-sx/ws-trust/200512/BatchIssue"));
                continue;
            }
            if (request.getRequestType().toString().equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512/BatchIssue")) continue;
            throw new IllegalArgumentException("The request type must be of type BatchIssue");
        }
        WSTrustJAXBFactory jaxbFactory = WSTrustJAXBFactory.getInstance();
        DOMSource requestSource = (DOMSource)jaxbFactory.marshallRequestSecurityTokenCollection(requestCollection);
        Source response = (Source)this.dispatchLocal.get().invoke((Object)requestSource);
        try {
            Node documentNode = DocumentUtil.getNodeFromSource(response);
            Document responseDoc = documentNode instanceof Document ? (Document)documentNode : documentNode.getOwnerDocument();
            nodes = null;
            if (responseDoc instanceof SOAPPart) {
                SOAPPart soapPart = (SOAPPart)responseDoc;
                SOAPEnvelope env = soapPart.getEnvelope();
                SOAPBody body = env.getBody();
                Node data = body.getFirstChild();
                nodes = ((Element)data).getElementsByTagNameNS("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "RequestedSecurityToken");
                if (nodes == null || nodes.getLength() == 0) {
                    nodes = ((Element)data).getElementsByTagName("RequestedSecurityToken");
                }
            } else {
                nodes = responseDoc.getElementsByTagNameNS("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "RequestedSecurityToken");
                if (nodes == null || nodes.getLength() == 0) {
                    nodes = responseDoc.getElementsByTagName("RequestedSecurityToken");
                }
            }
        }
        catch (Exception e) {
            throw new WSTrustException("Exception in issuing token:", e);
        }
        if (nodes == null) {
            throw new WSTrustException("NodeList is null");
        }
        ArrayList<Element> tokens = new ArrayList<Element>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            tokens.add((Element)node.getFirstChild());
        }
        return tokens;
    }

    public Element renewToken(String tokenType, Element token) throws WSTrustException {
        return this.renewToken(token);
    }

    public Element renewToken(Element token) throws WSTrustException {
        ArrayList<Element> tokens = new ArrayList<Element>();
        tokens.add(token);
        return this.renewTokens(tokens).get(0);
    }

    public List<Element> renewTokens(List<Element> tokens) throws WSTrustException {
        NodeList nodes;
        RequestSecurityTokenCollection requestCollection = new RequestSecurityTokenCollection();
        for (Element token : tokens) {
            RequestSecurityToken request = new RequestSecurityToken();
            request.setRequestType(URI.create("http://docs.oasis-open.org/ws-sx/ws-trust/200512/BatchRenew"));
            RenewTargetType renewTarget = new RenewTargetType();
            renewTarget.setAny(token);
            request.setRenewTarget(renewTarget);
            requestCollection.addRequestSecurityToken(request);
        }
        WSTrustJAXBFactory jaxbFactory = WSTrustJAXBFactory.getInstance();
        DOMSource requestSource = (DOMSource)jaxbFactory.marshallRequestSecurityTokenCollection(requestCollection);
        Source response = (Source)this.dispatchLocal.get().invoke((Object)requestSource);
        try {
            Node documentNode = DocumentUtil.getNodeFromSource(response);
            Document responseDoc = documentNode instanceof Document ? (Document)documentNode : documentNode.getOwnerDocument();
            nodes = null;
            if (responseDoc instanceof SOAPPart) {
                SOAPPart soapPart = (SOAPPart)responseDoc;
                SOAPEnvelope env = soapPart.getEnvelope();
                SOAPBody body = env.getBody();
                Node data = body.getFirstChild();
                nodes = ((Element)data).getElementsByTagNameNS("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "RequestedSecurityToken");
                if (nodes == null || nodes.getLength() == 0) {
                    nodes = ((Element)data).getElementsByTagName("RequestedSecurityToken");
                }
            } else {
                nodes = responseDoc.getElementsByTagNameNS("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "RequestedSecurityToken");
                if (nodes == null || nodes.getLength() == 0) {
                    nodes = responseDoc.getElementsByTagName("RequestedSecurityToken");
                }
            }
        }
        catch (Exception e) {
            throw new WSTrustException("Exception in issuing token:", e);
        }
        if (nodes == null) {
            throw new WSTrustException("NodeList is null");
        }
        ArrayList<Element> renewedTokens = new ArrayList<Element>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            renewedTokens.add((Element)node.getFirstChild());
        }
        return renewedTokens;
    }

    public boolean validateToken(Element token) throws WSTrustException {
        ArrayList<Element> tokens = new ArrayList<Element>();
        tokens.add(token);
        return this.validateTokens(tokens).get(0);
    }

    public List<Boolean> validateTokens(List<Element> tokens) throws WSTrustException {
        RequestSecurityTokenCollection requestCollection = new RequestSecurityTokenCollection();
        for (Element token : tokens) {
            RequestSecurityToken request = new RequestSecurityToken();
            request.setTokenType(URI.create("http://docs.oasis-open.org/ws-sx/ws-trust/200512/RSTR/Status"));
            request.setRequestType(URI.create("http://docs.oasis-open.org/ws-sx/ws-trust/200512/BatchValidate"));
            ValidateTargetType validateTarget = new ValidateTargetType();
            validateTarget.setAny(token);
            request.setValidateTarget(validateTarget);
            requestCollection.addRequestSecurityToken(request);
        }
        WSTrustJAXBFactory jaxbFactory = WSTrustJAXBFactory.getInstance();
        DOMSource requestSource = (DOMSource)jaxbFactory.marshallRequestSecurityTokenCollection(requestCollection);
        Source response = (Source)this.dispatchLocal.get().invoke((Object)requestSource);
        RequestSecurityTokenResponseCollection responseCollection = (RequestSecurityTokenResponseCollection)jaxbFactory.parseRequestSecurityTokenResponse(response);
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        for (RequestSecurityTokenResponse tokenResponse : responseCollection.getRequestSecurityTokenResponses()) {
            StatusType status = tokenResponse.getStatus();
            if (status != null) {
                String code = status.getCode();
                result.add("http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/valid".equals(code));
            }
            result.add(Boolean.FALSE);
        }
        return result;
    }

    public boolean cancelToken(Element securityToken) throws WSTrustException {
        ArrayList<Element> tokens = new ArrayList<Element>();
        tokens.add(securityToken);
        return this.cancelTokens(tokens).get(0);
    }

    public List<Boolean> cancelTokens(List<Element> tokens) throws WSTrustException {
        RequestSecurityTokenCollection requestCollection = new RequestSecurityTokenCollection();
        for (Element token : tokens) {
            RequestSecurityToken request = new RequestSecurityToken();
            request.setRequestType(URI.create("http://docs.oasis-open.org/ws-sx/ws-trust/200512/BatchCancel"));
            CancelTargetType cancelTarget = new CancelTargetType();
            cancelTarget.setAny(token);
            request.setCancelTarget(cancelTarget);
            requestCollection.addRequestSecurityToken(request);
        }
        WSTrustJAXBFactory jaxbFactory = WSTrustJAXBFactory.getInstance();
        DOMSource requestSource = (DOMSource)jaxbFactory.marshallRequestSecurityTokenCollection(requestCollection);
        Source response = (Source)this.dispatchLocal.get().invoke((Object)requestSource);
        RequestSecurityTokenResponseCollection responseCollection = (RequestSecurityTokenResponseCollection)jaxbFactory.parseRequestSecurityTokenResponse(response);
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        for (RequestSecurityTokenResponse tokenResponse : responseCollection.getRequestSecurityTokenResponses()) {
            if (tokenResponse.getRequestedTokenCancelled() != null) {
                result.add(Boolean.TRUE);
            }
            result.add(Boolean.FALSE);
        }
        return result;
    }

    public Dispatch<Source> getDispatch() {
        return this.dispatchLocal.get();
    }
}

