/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust;

import java.util.ArrayList;
import javax.xml.bind.Binder;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.transform.Source;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.core.saml.v2.common.SAMLDocumentHolder;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.util.JAXBUtil;
import org.picketlink.identity.federation.core.wstrust.WSTrustException;
import org.picketlink.identity.federation.core.wstrust.wrappers.BaseRequestSecurityToken;
import org.picketlink.identity.federation.core.wstrust.wrappers.BaseRequestSecurityTokenResponse;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityToken;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityTokenCollection;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityTokenResponse;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityTokenResponseCollection;
import org.picketlink.identity.federation.ws.trust.ObjectFactory;
import org.picketlink.identity.federation.ws.trust.RequestSecurityTokenCollectionType;
import org.picketlink.identity.federation.ws.trust.RequestSecurityTokenResponseCollectionType;
import org.picketlink.identity.federation.ws.trust.RequestSecurityTokenType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSTrustJAXBFactory {
    private static Logger log = Logger.getLogger(WSTrustJAXBFactory.class);
    private boolean trace = log.isTraceEnabled();
    private static final WSTrustJAXBFactory instance = new WSTrustJAXBFactory();
    private Marshaller marshaller;
    private Binder<Node> binder;
    private final ObjectFactory objectFactory;
    private ThreadLocal<SAMLDocumentHolder> holders = new ThreadLocal();

    private WSTrustJAXBFactory() {
        try {
            this.marshaller = JAXBUtil.getMarshaller(this.getPackages());
            this.binder = JAXBUtil.getJAXBContext(this.getPackages()).createBinder();
            this.objectFactory = new ObjectFactory();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static WSTrustJAXBFactory getInstance() {
        return instance;
    }

    private String getPackages() {
        StringBuilder packages = new StringBuilder();
        packages.append("org.picketlink.identity.federation.ws.addressing");
        packages.append(":org.picketlink.identity.federation.ws.policy");
        packages.append(":org.picketlink.identity.federation.ws.trust");
        packages.append(":org.picketlink.identity.federation.ws.wss.secext");
        packages.append(":org.picketlink.identity.federation.ws.wss.utility");
        packages.append(":org.picketlink.identity.xmlsec.w3.xmldsig");
        return packages.toString();
    }

    public BaseRequestSecurityToken parseRequestSecurityToken(Source request) throws WSTrustException {
        try {
            Node documentNode = DocumentUtil.getNodeFromSource(request);
            Document document = documentNode instanceof Document ? (Document)documentNode : documentNode.getOwnerDocument();
            Node rst = this.findNodeByNameNS(document, "RequestSecurityToken", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
            if (rst == null) {
                throw new RuntimeException("The request document must contain at least one RequestSecurityToken node");
            }
            JAXBElement jaxbRST = (JAXBElement)this.binder.unmarshal((Object)document);
            if (jaxbRST.getDeclaredType().equals(RequestSecurityTokenType.class)) {
                RequestSecurityTokenType rstt = (RequestSecurityTokenType)jaxbRST.getValue();
                RequestSecurityToken requestSecToken = new RequestSecurityToken(rstt);
                requestSecToken.setRSTDocument(document);
                return requestSecToken;
            }
            if (jaxbRST.getDeclaredType().equals(RequestSecurityTokenCollectionType.class)) {
                RequestSecurityTokenCollectionType rstct = (RequestSecurityTokenCollectionType)jaxbRST.getValue();
                RequestSecurityTokenCollection requestSecTokenCollection = new RequestSecurityTokenCollection(rstct, document);
                return requestSecTokenCollection;
            }
            throw new WSTrustException("Request message doesn't contain a valid request type");
        }
        catch (Exception e) {
            throw new WSTrustException("Error parsing security token request", e);
        }
    }

    public BaseRequestSecurityTokenResponse parseRequestSecurityTokenResponse(Source response) throws WSTrustException {
        Node documentNode = null;
        try {
            documentNode = DocumentUtil.getNodeFromSource(response);
        }
        catch (Exception e) {
            throw new WSTrustException("Failed to transform request source", e);
        }
        try {
            Object object = this.binder.unmarshal((Object)documentNode);
            if (object instanceof JAXBElement) {
                JAXBElement element = (JAXBElement)object;
                if (element.getDeclaredType().equals(RequestSecurityTokenResponseCollectionType.class)) {
                    RequestSecurityTokenResponseCollection collection = new RequestSecurityTokenResponseCollection((RequestSecurityTokenResponseCollectionType)element.getValue());
                    return collection;
                }
                throw new RuntimeException("Invalid response type: " + element.getDeclaredType());
            }
            throw new RuntimeException("Invalid response type: " + object.getClass().getName());
        }
        catch (JAXBException e) {
            throw new RuntimeException("Failed to unmarshall security token response", e);
        }
    }

    public Source marshallRequestSecurityToken(RequestSecurityToken request) {
        Element targetElement = null;
        String requestType = request.getRequestType().toString();
        if (requestType.equalsIgnoreCase("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Validate") && request.getValidateTarget() != null) {
            targetElement = (Element)request.getValidateTarget().getAny();
            request.getValidateTarget().setAny(null);
        } else if (requestType.equalsIgnoreCase("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Renew") && request.getRenewTarget() != null) {
            targetElement = (Element)request.getRenewTarget().getAny();
            request.getRenewTarget().setAny(null);
        } else if (requestType.equalsIgnoreCase("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Cancel") && request.getCancelTarget() != null) {
            targetElement = (Element)request.getCancelTarget().getAny();
            request.getCancelTarget().setAny(null);
        }
        Document result = null;
        try {
            result = DocumentUtil.createDocument();
            this.binder.marshal(this.objectFactory.createRequestSecurityToken(request.getDelegate()), (Object)result);
            if (targetElement != null) {
                Node node = null;
                if (requestType.equalsIgnoreCase("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Validate")) {
                    node = this.findNodeByNameNS(result, "ValidateTarget", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
                } else if (requestType.equalsIgnoreCase("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Renew")) {
                    node = this.findNodeByNameNS(result, "RenewTarget", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
                } else if (requestType.equalsIgnoreCase("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Cancel")) {
                    node = this.findNodeByNameNS(result, "CancelTarget", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
                }
                if (node == null) {
                    throw new RuntimeException("Unsupported request type:" + requestType);
                }
                node.appendChild(result.importNode(targetElement, true));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to marshall security token request", e);
        }
        return DocumentUtil.getXMLSource(result);
    }

    public Source marshallRequestSecurityTokenCollection(RequestSecurityTokenCollection collection) {
        if (collection == null || collection.getRequestSecurityTokens().size() == 0) {
            throw new IllegalArgumentException("The request collection must contain at least one request");
        }
        String requestType = null;
        for (RequestSecurityToken request : collection.getRequestSecurityTokens()) {
            if (requestType == null) {
                if (request.getRequestType() == null || !this.isValidBatchRequestType(request.getRequestType().toString())) {
                    throw new IllegalArgumentException("The request type cannot be null and must be a valid WS-Trust batch request type");
                }
                requestType = request.getRequestType().toString();
                continue;
            }
            if (request.getRequestType() != null && requestType.equals(request.getRequestType().toString())) continue;
            throw new IllegalArgumentException("All requests must be of the same type. Invalid type: " + request.getRequestType());
        }
        ArrayList<Element> targets = new ArrayList<Element>();
        for (RequestSecurityToken request : collection.getRequestSecurityTokens()) {
            if (requestType.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512/BatchCancel")) {
                targets.add((Element)request.getCancelTarget().getAny());
                request.getCancelTarget().setAny(null);
                continue;
            }
            if (requestType.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512/BatchRenew")) {
                targets.add((Element)request.getRenewTarget().getAny());
                request.getRenewTarget().setAny(null);
                continue;
            }
            if (!requestType.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512/BatchValidate")) continue;
            targets.add((Element)request.getValidateTarget().getAny());
            request.getValidateTarget().setAny(null);
        }
        Document result = null;
        try {
            result = DocumentUtil.createDocument();
            this.binder.marshal(this.objectFactory.createRequestSecurityTokenCollection(collection.getDelegate()), (Object)result);
            NodeList nodes = null;
            if (requestType.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512/BatchCancel")) {
                nodes = result.getElementsByTagNameNS("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "CancelTarget");
            } else if (requestType.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512/BatchRenew")) {
                nodes = result.getElementsByTagNameNS("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "RenewTarget");
            } else if (requestType.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512/BatchValidate")) {
                nodes = result.getElementsByTagNameNS("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "ValidateTarget");
            }
            if (nodes != null) {
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    node.appendChild(result.importNode((Node)targets.get(i), true));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to marshall security token request", e);
        }
        return DocumentUtil.getXMLSource(result);
    }

    public Source marshallRequestSecurityTokenResponse(RequestSecurityTokenResponseCollection collection) {
        if (collection.getRequestSecurityTokenResponses().size() == 0) {
            throw new IllegalArgumentException("The response collection must contain at least one response");
        }
        ArrayList<Element> tokenElements = new ArrayList<Element>();
        for (RequestSecurityTokenResponse response : collection.getRequestSecurityTokenResponses()) {
            if (response.getRequestedSecurityToken() == null) continue;
            tokenElements.add((Element)response.getRequestedSecurityToken().getAny());
            response.getRequestedSecurityToken().setAny(null);
        }
        Document result = null;
        try {
            result = DocumentUtil.createDocument();
            this.marshaller.marshal(this.objectFactory.createRequestSecurityTokenResponseCollection(collection.getDelegate()), (Node)result);
            if (!tokenElements.isEmpty()) {
                NodeList nodes = result.getElementsByTagNameNS("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "RequestedSecurityToken");
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    node.appendChild(result.importNode((Node)tokenElements.get(i), true));
                }
            }
            if (this.trace) {
                log.trace((Object)("Final RSTR doc:" + DocumentUtil.asString(result)));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to marshall security token response", e);
        }
        return DocumentUtil.getXMLSource(result);
    }

    public SAMLDocumentHolder getSAMLDocumentHolderOnThread() {
        return this.holders.get();
    }

    private Node findNodeByNameNS(Document document, String localName, String namespace) {
        NodeList list = document.getElementsByTagNameNS(namespace, localName);
        if (list == null || list.getLength() == 0) {
            return null;
        }
        return list.item(0);
    }

    private boolean isValidBatchRequestType(String requestType) {
        return requestType.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512/BatchIssue") || requestType.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512/BatchRenew") || requestType.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512/BatchCancel") || requestType.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512/BatchValidate");
    }
}

