/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.GregorianCalendar;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.picketlink.identity.federation.core.config.STSType;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.util.JAXBUtil;
import org.picketlink.identity.federation.core.util.XMLEncryptionUtil;
import org.picketlink.identity.federation.core.wstrust.WSTrustException;
import org.picketlink.identity.federation.core.wstrust.wrappers.Lifetime;
import org.picketlink.identity.federation.ws.addressing.AttributedURIType;
import org.picketlink.identity.federation.ws.addressing.EndpointReferenceType;
import org.picketlink.identity.federation.ws.addressing.ObjectFactory;
import org.picketlink.identity.federation.ws.policy.AppliesTo;
import org.picketlink.identity.federation.ws.trust.BinarySecretType;
import org.picketlink.identity.federation.ws.trust.EntropyType;
import org.picketlink.identity.federation.ws.trust.OnBehalfOfType;
import org.picketlink.identity.federation.ws.trust.RequestedReferenceType;
import org.picketlink.identity.federation.ws.wss.secext.AttributedString;
import org.picketlink.identity.federation.ws.wss.secext.KeyIdentifierType;
import org.picketlink.identity.federation.ws.wss.secext.SecurityTokenReferenceType;
import org.picketlink.identity.federation.ws.wss.secext.UsernameTokenType;
import org.picketlink.identity.xmlsec.w3.xmldsig.DSAKeyValueType;
import org.picketlink.identity.xmlsec.w3.xmldsig.KeyInfoType;
import org.picketlink.identity.xmlsec.w3.xmldsig.KeyValueType;
import org.picketlink.identity.xmlsec.w3.xmldsig.RSAKeyValueType;
import org.picketlink.identity.xmlsec.w3.xmldsig.X509DataType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSTrustUtil {
    private static Logger logger = Logger.getLogger(WSTrustUtil.class);

    public static KeyIdentifierType createKeyIdentifier(String valueType, String value) {
        KeyIdentifierType keyIdentifier = new KeyIdentifierType();
        keyIdentifier.setValueType(valueType);
        keyIdentifier.setValue(value);
        return keyIdentifier;
    }

    public static RequestedReferenceType createRequestedReference(KeyIdentifierType keyIdentifier, Map<QName, String> attributes) {
        SecurityTokenReferenceType securityTokenReference = new SecurityTokenReferenceType();
        securityTokenReference.getAny().add(new org.picketlink.identity.federation.ws.wss.secext.ObjectFactory().createKeyIdentifier(keyIdentifier));
        securityTokenReference.getOtherAttributes().putAll(attributes);
        RequestedReferenceType reference = new RequestedReferenceType();
        reference.setSecurityTokenReference(securityTokenReference);
        return reference;
    }

    public static AppliesTo createAppliesTo(String endpointURI) {
        AttributedURIType attributedURI = new AttributedURIType();
        attributedURI.setValue(endpointURI);
        EndpointReferenceType reference = new EndpointReferenceType();
        reference.setAddress(attributedURI);
        AppliesTo appliesTo = new AppliesTo();
        appliesTo.getAny().add(new ObjectFactory().createEndpointReference(reference));
        return appliesTo;
    }

    public static String parseAppliesTo(AppliesTo appliesTo) {
        EndpointReferenceType reference = null;
        for (Object obj : appliesTo.getAny()) {
            JAXBElement element;
            if (obj instanceof EndpointReferenceType) {
                reference = (EndpointReferenceType)obj;
            } else if (obj instanceof JAXBElement && (element = (JAXBElement)obj).getName().getLocalPart().equalsIgnoreCase("EndpointReference")) {
                reference = (EndpointReferenceType)element.getValue();
            }
            if (reference == null || reference.getAddress() == null) continue;
            return reference.getAddress().getValue();
        }
        return null;
    }

    public static Lifetime createDefaultLifetime(long tokenTimeout) {
        GregorianCalendar created = new GregorianCalendar();
        GregorianCalendar expires = new GregorianCalendar();
        expires.setTimeInMillis(created.getTimeInMillis() + tokenTimeout);
        return new Lifetime(created, expires);
    }

    public static Principal getOnBehalfOfPrincipal(OnBehalfOfType onBehalfOf) {
        JAXBElement element;
        UsernameTokenType usernameToken = null;
        Object content = onBehalfOf.getAny();
        if (content instanceof UsernameTokenType) {
            usernameToken = (UsernameTokenType)content;
        } else if (content instanceof JAXBElement && (element = (JAXBElement)content).getName().getLocalPart().equalsIgnoreCase("UsernameToken")) {
            usernameToken = (UsernameTokenType)element.getValue();
        }
        if (usernameToken != null && usernameToken.getUsername() != null) {
            final String username = usernameToken.getUsername().getValue();
            return new Principal(){

                public String getName() {
                    return username;
                }
            };
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Unable to parse the contents of the OnBehalfOfType: " + onBehalfOf.getAny()));
        }
        return null;
    }

    public static OnBehalfOfType createOnBehalfOfWithUsername(String username, String id) {
        org.picketlink.identity.federation.ws.wss.secext.ObjectFactory secextFactory = new org.picketlink.identity.federation.ws.wss.secext.ObjectFactory();
        AttributedString attrString = new AttributedString();
        attrString.setValue(username);
        UsernameTokenType usernameToken = new UsernameTokenType();
        usernameToken.setId(id);
        usernameToken.setUsername(attrString);
        OnBehalfOfType onBehalfOf = new OnBehalfOfType();
        onBehalfOf.setAny(secextFactory.createUsernameToken(usernameToken));
        return onBehalfOf;
    }

    public static byte[] getBinarySecret(EntropyType entropy) {
        byte[] secret = null;
        for (Object obj : entropy.getAny()) {
            JAXBElement element = (JAXBElement)obj;
            if (!element.getDeclaredType().equals(BinarySecretType.class)) continue;
            BinarySecretType binarySecret = (BinarySecretType)element.getValue();
            secret = binarySecret.getValue();
            break;
        }
        return secret;
    }

    public static STSType getSTSConfiguration(InputStream stream) throws JAXBException {
        String pkgName = "org.picketlink.identity.federation.core.config";
        JAXBElement element = (JAXBElement)JAXBUtil.getUnmarshaller(pkgName).unmarshal(stream);
        return (STSType)element.getValue();
    }

    public static void persistSTSConfiguration(STSType stsConfiguration, OutputStream outputStream) throws JAXBException {
        String pkgName = "org.picketlink.identity.federation.core.config";
        Marshaller marshaller = JAXBUtil.getMarshaller(pkgName);
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        org.picketlink.identity.federation.core.config.ObjectFactory objectFactory = new org.picketlink.identity.federation.core.config.ObjectFactory();
        marshaller.marshal(objectFactory.createPicketLinkSTS(stsConfiguration), outputStream);
    }

    public static byte[] createRandomSecret(int size) {
        SecureRandom random = new SecureRandom();
        byte[] secret = new byte[size];
        random.nextBytes(secret);
        return secret;
    }

    public static byte[] P_SHA1(byte[] secret, byte[] seed, int requiredSize) throws NoSuchAlgorithmException, InvalidKeyException {
        int offset = 0;
        byte[] result = new byte[requiredSize];
        SecretKeySpec key = new SecretKeySpec(secret, "HMACSHA1");
        Mac mac = Mac.getInstance("HMACSHA1");
        byte[] A = seed;
        while (requiredSize > 0) {
            mac.init(key);
            mac.update(A);
            A = mac.doFinal();
            mac.reset();
            mac.init(key);
            mac.update(A);
            mac.update(seed);
            byte[] partialResult = mac.doFinal();
            int copySize = Math.min(requiredSize, partialResult.length);
            System.arraycopy(partialResult, 0, result, offset, copySize);
            offset += copySize;
            requiredSize -= copySize;
        }
        return result;
    }

    public static KeyInfoType createKeyInfo(byte[] secret, PublicKey encryptionKey, URI keyWrapAlgo) throws WSTrustException {
        KeyInfoType keyInfo = null;
        if (encryptionKey != null) {
            try {
                Document document = DocumentUtil.createDocument();
                EncryptedKey key = XMLEncryptionUtil.encryptKey(document, new SecretKeySpec(secret, "AES"), encryptionKey, secret.length * 8);
                Element encryptedKeyElement = XMLCipher.getInstance().martial(key);
                keyInfo = new KeyInfoType();
                keyInfo.getContent().add(encryptedKeyElement);
            }
            catch (Exception e) {
                throw new WSTrustException("Error creating KeyInfoType", e);
            }
        } else {
            logger.warn((Object)"Secret key could not be encrypted because the endpoint's PKC has not been specified");
        }
        return keyInfo;
    }

    public static KeyInfoType createKeyInfo(Certificate certificate) throws WSTrustException {
        KeyInfoType keyInfo = null;
        try {
            byte[] encodedCert = certificate.getEncoded();
            org.picketlink.identity.xmlsec.w3.xmldsig.ObjectFactory factory = new org.picketlink.identity.xmlsec.w3.xmldsig.ObjectFactory();
            X509DataType dataType = factory.createX509DataType();
            dataType.getX509IssuerSerialOrX509SKIOrX509SubjectName().add(factory.createX509DataTypeX509Certificate(encodedCert));
            keyInfo = new KeyInfoType();
            keyInfo.getContent().add(factory.createX509Data(dataType));
        }
        catch (Exception e) {
            throw new WSTrustException("Error creating KeyInfoType", e);
        }
        return keyInfo;
    }

    public static KeyValueType createKeyValue(PublicKey key) {
        org.picketlink.identity.xmlsec.w3.xmldsig.ObjectFactory factory = new org.picketlink.identity.xmlsec.w3.xmldsig.ObjectFactory();
        if (key instanceof RSAPublicKey) {
            RSAPublicKey pubKey = (RSAPublicKey)key;
            byte[] modulus = pubKey.getModulus().toByteArray();
            byte[] exponent = pubKey.getPublicExponent().toByteArray();
            RSAKeyValueType rsaKeyValue = new RSAKeyValueType();
            rsaKeyValue.setModulus(modulus);
            rsaKeyValue.setExponent(exponent);
            KeyValueType keyValue = new KeyValueType();
            keyValue.getContent().add(factory.createRSAKeyValue(rsaKeyValue));
            return keyValue;
        }
        if (key instanceof DSAPublicKey) {
            DSAPublicKey pubKey = (DSAPublicKey)key;
            byte[] P = pubKey.getParams().getP().toByteArray();
            byte[] Q = pubKey.getParams().getQ().toByteArray();
            byte[] G = pubKey.getParams().getG().toByteArray();
            byte[] Y = pubKey.getY().toByteArray();
            DSAKeyValueType dsaKeyValue = new DSAKeyValueType();
            dsaKeyValue.setP(P);
            dsaKeyValue.setQ(Q);
            dsaKeyValue.setG(G);
            dsaKeyValue.setY(Y);
            KeyValueType keyValue = new KeyValueType();
            keyValue.getContent().add(factory.createDSAKeyValue(dsaKeyValue));
            return keyValue;
        }
        return null;
    }
}

