/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust.confighandlers;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.core.config.STSType;
import org.picketlink.identity.federation.core.wstrust.PicketLinkSTSConfiguration;
import org.picketlink.identity.federation.core.wstrust.PicketLinkSTSConstants;
import org.picketlink.identity.federation.core.wstrust.STSConfiguration;
import org.picketlink.identity.federation.core.wstrust.WSTrustUtil;
import org.picketlink.identity.federation.core.wstrust.confighandlers.BaseSTSConfigHandler;

public class ConsoleHomeDirectoryConfigHandler
extends BaseSTSConfigHandler {
    protected static Logger log = Logger.getLogger(ConsoleHomeDirectoryConfigHandler.class);

    public STSConfiguration getConfiguration() {
        PicketLinkSTSConfiguration configuration;
        block3: {
            configuration = null;
            URL configurationFileURL = null;
            try {
                StringBuilder builder = new StringBuilder(PicketLinkSTSConstants.USER_HOME_DIR);
                builder.append(PicketLinkSTSConstants.SEPARATOR);
                builder.append(PicketLinkSTSConstants.STS_CONFIG_DIR);
                builder.append("picketlink-sts.xml");
                String configurationFilePath = builder.toString();
                File configurationFile = new File(configurationFilePath);
                if (configurationFile != null && configurationFile.exists()) {
                    configurationFileURL = configurationFile.toURI().toURL();
                    InputStream stream = configurationFileURL.openStream();
                    STSType stsConfig = WSTrustUtil.getSTSConfiguration(stream);
                    configuration = new PicketLinkSTSConfiguration(stsConfig);
                }
            }
            catch (Exception e) {
                if (!log.isTraceEnabled()) break block3;
                log.trace((Object)"Error in handling Console based configuration in home directory:", (Throwable)e);
            }
        }
        return configuration;
    }
}

