/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust.plugins;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.core.wstrust.plugins.RevocationRegistry;

public class FileBasedRevocationRegistry
implements RevocationRegistry {
    private static Logger logger = Logger.getLogger(FileBasedRevocationRegistry.class);
    private static Set<String> revokedIds = new HashSet<String>();
    private File registryFile;

    public FileBasedRevocationRegistry() {
        StringBuilder builder = new StringBuilder();
        builder.append(System.getProperty("user.home"));
        builder.append(System.getProperty("file.separator") + "picketlink-store");
        builder.append(System.getProperty("file.separator") + "sts");
        File directory = new File(builder.toString());
        if (!directory.exists()) {
            directory.mkdirs();
        }
        this.registryFile = new File(directory, "revoked.ids");
        if (!this.registryFile.exists()) {
            try {
                this.registryFile.createNewFile();
            }
            catch (IOException ioe) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Error creating default registry file: " + ioe.getMessage()));
                }
                ioe.printStackTrace();
            }
        }
        this.loadRevokedIds();
    }

    public FileBasedRevocationRegistry(String registryFile) {
        if (registryFile == null) {
            throw new IllegalArgumentException("The revoked ids file cannot be null");
        }
        this.registryFile = new File(registryFile);
        if (!this.registryFile.exists()) {
            try {
                this.registryFile.createNewFile();
            }
            catch (IOException ioe) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Error creating registry file: " + ioe.getMessage()));
                }
                ioe.printStackTrace();
            }
        }
        this.loadRevokedIds();
    }

    public boolean isRevoked(String tokenType, String id) {
        return revokedIds.contains(id);
    }

    public synchronized void revokeToken(String tokenType, String id) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.registryFile, true));
            writer.write(id + "\n");
            writer.close();
        }
        catch (IOException ioe) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Error appending content to registry file: " + ioe.getMessage()));
            }
            ioe.printStackTrace();
        }
        revokedIds.add(id);
    }

    private void loadRevokedIds() {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.registryFile));
            String id = reader.readLine();
            while (id != null) {
                revokedIds.add(id);
                id = reader.readLine();
            }
            reader.close();
        }
        catch (IOException ioe) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Error opening registry file: " + ioe.getMessage()));
            }
            ioe.printStackTrace();
        }
    }
}

