/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust.plugins;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.core.wstrust.plugins.RevocationRegistry;
import org.picketlink.identity.federation.core.wstrust.plugins.RevokedToken;

public class JPABasedRevocationRegistry
implements RevocationRegistry {
    private static Logger logger = Logger.getLogger(JPABasedRevocationRegistry.class);
    private EntityManagerFactory factory;

    public JPABasedRevocationRegistry() {
        this("picketlink-sts");
    }

    public JPABasedRevocationRegistry(String configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("The JPA configuration name cannot be null");
        }
        this.factory = Persistence.createEntityManagerFactory((String)configuration);
    }

    public boolean isRevoked(String tokenType, String id) {
        EntityManager manager = this.factory.createEntityManager();
        Object object = manager.find(RevokedToken.class, (Object)id);
        manager.close();
        return object != null;
    }

    public void revokeToken(String tokenType, String id) {
        EntityManager manager = this.factory.createEntityManager();
        if (manager.find(RevokedToken.class, (Object)id) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Token with id=" + id + " has already been cancelled"));
            }
        } else {
            RevokedToken revokedToken = new RevokedToken(tokenType, id);
            EntityTransaction transaction = manager.getTransaction();
            transaction.begin();
            manager.persist((Object)revokedToken);
            transaction.commit();
        }
        manager.close();
    }
}

