/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust.wrappers;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.picketlink.identity.federation.core.wstrust.wrappers.BaseRequestSecurityToken;
import org.picketlink.identity.federation.core.wstrust.wrappers.Lifetime;
import org.picketlink.identity.federation.ws.addressing.EndpointReferenceType;
import org.picketlink.identity.federation.ws.policy.AppliesTo;
import org.picketlink.identity.federation.ws.policy.Policy;
import org.picketlink.identity.federation.ws.policy.PolicyReference;
import org.picketlink.identity.federation.ws.trust.AllowPostdatingType;
import org.picketlink.identity.federation.ws.trust.CancelTargetType;
import org.picketlink.identity.federation.ws.trust.ClaimsType;
import org.picketlink.identity.federation.ws.trust.DelegateToType;
import org.picketlink.identity.federation.ws.trust.EncryptionType;
import org.picketlink.identity.federation.ws.trust.EntropyType;
import org.picketlink.identity.federation.ws.trust.LifetimeType;
import org.picketlink.identity.federation.ws.trust.ObjectFactory;
import org.picketlink.identity.federation.ws.trust.OnBehalfOfType;
import org.picketlink.identity.federation.ws.trust.ProofEncryptionType;
import org.picketlink.identity.federation.ws.trust.RenewTargetType;
import org.picketlink.identity.federation.ws.trust.RenewingType;
import org.picketlink.identity.federation.ws.trust.RequestSecurityTokenType;
import org.picketlink.identity.federation.ws.trust.UseKeyType;
import org.picketlink.identity.federation.ws.trust.ValidateTargetType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestSecurityToken
implements BaseRequestSecurityToken {
    private final RequestSecurityTokenType delegate;
    private URI tokenType;
    private URI requestType;
    private AppliesTo appliesTo;
    private ClaimsType claims;
    private EntropyType entropy;
    private Lifetime lifetime;
    private AllowPostdatingType allowPostDating;
    private RenewingType renewing;
    private OnBehalfOfType onBehalfOf;
    private EndpointReferenceType issuer;
    private URI authenticationType;
    private URI keyType;
    private long keySize;
    private URI signatureAlgorithm;
    private EncryptionType encryption;
    private URI encryptionAlgorithm;
    private URI canonicalizationAlgorithm;
    private URI keyWrapAlgorithm;
    private ProofEncryptionType proofEncryption;
    private UseKeyType useKey;
    private URI signWith;
    private URI encryptWith;
    private DelegateToType delegateTo;
    private boolean forwardable;
    private boolean delegatable;
    private Policy policy;
    private PolicyReference policyReference;
    private ValidateTargetType validateTarget;
    private RenewTargetType renewTarget;
    private CancelTargetType cancelTarget;
    private final List<Object> extensionElements = new ArrayList<Object>();
    private final ObjectFactory factory = new ObjectFactory();
    private Document rstDocument;

    public RequestSecurityToken() {
        this.delegate = new RequestSecurityTokenType();
    }

    public RequestSecurityToken(RequestSecurityTokenType delegate) {
        this.delegate = delegate;
        for (Object obj : this.delegate.getAny()) {
            if (obj instanceof AppliesTo) {
                this.appliesTo = (AppliesTo)obj;
                continue;
            }
            if (obj instanceof Policy) {
                this.policy = (Policy)obj;
                continue;
            }
            if (obj instanceof PolicyReference) {
                this.policyReference = (PolicyReference)obj;
                continue;
            }
            if (obj instanceof JAXBElement) {
                JAXBElement element = (JAXBElement)obj;
                String localName = element.getName().getLocalPart();
                if (localName.equalsIgnoreCase("TokenType")) {
                    this.tokenType = URI.create((String)element.getValue());
                    continue;
                }
                if (localName.equalsIgnoreCase("RequestType")) {
                    this.requestType = URI.create((String)element.getValue());
                    continue;
                }
                if (localName.equalsIgnoreCase("Claims")) {
                    this.claims = (ClaimsType)element.getValue();
                    continue;
                }
                if (localName.equalsIgnoreCase("Entropy")) {
                    this.entropy = (EntropyType)element.getValue();
                    continue;
                }
                if (localName.equalsIgnoreCase("Lifetime")) {
                    this.lifetime = new Lifetime((LifetimeType)element.getValue());
                    continue;
                }
                if (localName.equalsIgnoreCase("AllowPostdating")) {
                    this.allowPostDating = (AllowPostdatingType)element.getValue();
                    continue;
                }
                if (localName.equalsIgnoreCase("Renewing")) {
                    this.renewing = (RenewingType)element.getValue();
                    continue;
                }
                if (localName.equalsIgnoreCase("OnBehalfOf")) {
                    this.onBehalfOf = (OnBehalfOfType)element.getValue();
                    continue;
                }
                if (localName.equalsIgnoreCase("Issuer")) {
                    this.issuer = (EndpointReferenceType)element.getValue();
                    continue;
                }
                if (localName.equalsIgnoreCase("AuthenticationType")) {
                    this.authenticationType = URI.create((String)element.getValue());
                    continue;
                }
                if (localName.equalsIgnoreCase("KeyType")) {
                    this.keyType = URI.create((String)element.getValue());
                    continue;
                }
                if (localName.equalsIgnoreCase("KeySize")) {
                    this.keySize = (Long)element.getValue();
                    continue;
                }
                if (localName.equalsIgnoreCase("SignatureAlgorithm")) {
                    this.signatureAlgorithm = URI.create((String)element.getValue());
                    continue;
                }
                if (localName.equalsIgnoreCase("Encryption")) {
                    this.encryption = (EncryptionType)element.getValue();
                    continue;
                }
                if (localName.equalsIgnoreCase("EntropyAlgorithm")) {
                    this.encryptionAlgorithm = URI.create((String)element.getValue());
                    continue;
                }
                if (localName.equalsIgnoreCase("CanonicalizationAlgorithm")) {
                    this.canonicalizationAlgorithm = URI.create((String)element.getValue());
                    continue;
                }
                if (localName.equalsIgnoreCase("KeyWrapAlgorithm")) {
                    this.keyWrapAlgorithm = URI.create((String)element.getValue());
                    continue;
                }
                if (localName.equalsIgnoreCase("ProofEncryption")) {
                    this.proofEncryption = (ProofEncryptionType)element.getValue();
                    continue;
                }
                if (localName.equalsIgnoreCase("UseKey")) {
                    this.useKey = (UseKeyType)element.getValue();
                    continue;
                }
                if (localName.equalsIgnoreCase("SignWith")) {
                    this.signWith = URI.create((String)element.getValue());
                    continue;
                }
                if (localName.equalsIgnoreCase("EncryptWith")) {
                    this.encryptWith = URI.create((String)element.getValue());
                    continue;
                }
                if (localName.equalsIgnoreCase("DelegateTo")) {
                    this.delegateTo = (DelegateToType)element.getValue();
                    continue;
                }
                if (localName.equalsIgnoreCase("Forwardable")) {
                    this.forwardable = (Boolean)element.getValue();
                    continue;
                }
                if (localName.equalsIgnoreCase("Delegatable")) {
                    this.delegatable = (Boolean)element.getValue();
                    continue;
                }
                if (localName.equalsIgnoreCase("CancelTarget")) {
                    this.cancelTarget = (CancelTargetType)element.getValue();
                    continue;
                }
                if (localName.equalsIgnoreCase("RenewTarget")) {
                    this.renewTarget = (RenewTargetType)element.getValue();
                    continue;
                }
                if (localName.equalsIgnoreCase("ValidateTarget")) {
                    this.validateTarget = (ValidateTargetType)element.getValue();
                    continue;
                }
                this.extensionElements.add(element.getValue());
                continue;
            }
            this.extensionElements.add(obj);
        }
    }

    public URI getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(URI tokenType) {
        this.tokenType = tokenType;
        this.delegate.getAny().add(this.factory.createTokenType(tokenType.toString()));
    }

    public URI getRequestType() {
        return this.requestType;
    }

    public void setRequestType(URI requestType) {
        this.requestType = requestType;
        this.delegate.getAny().add(this.factory.createRequestType(requestType.toString()));
    }

    public AppliesTo getAppliesTo() {
        return this.appliesTo;
    }

    public void setAppliesTo(AppliesTo appliesTo) {
        this.appliesTo = appliesTo;
        this.delegate.getAny().add(appliesTo);
    }

    public ClaimsType getClaims() {
        return this.claims;
    }

    public void setClaims(ClaimsType claims) {
        this.claims = claims;
        this.delegate.getAny().add(this.factory.createClaims(claims));
    }

    public EntropyType getEntropy() {
        return this.entropy;
    }

    public void setEntropy(EntropyType entropy) {
        this.entropy = entropy;
        this.delegate.getAny().add(this.factory.createEntropy(entropy));
    }

    public Lifetime getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(Lifetime lifetime) {
        this.lifetime = lifetime;
        this.delegate.getAny().add(this.factory.createLifetime(lifetime.getDelegate()));
    }

    public AllowPostdatingType getAllowPostDating() {
        return this.allowPostDating;
    }

    public void setAllowPostDating(AllowPostdatingType allowPostDating) {
        this.allowPostDating = allowPostDating;
        this.delegate.getAny().add(this.factory.createAllowPostdating(allowPostDating));
    }

    public RenewingType getRenewing() {
        return this.renewing;
    }

    public void setRenewing(RenewingType renewing) {
        this.renewing = renewing;
        this.delegate.getAny().add(this.factory.createRenewing(renewing));
    }

    public OnBehalfOfType getOnBehalfOf() {
        return this.onBehalfOf;
    }

    public void setOnBehalfOf(OnBehalfOfType onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
        this.delegate.getAny().add(this.factory.createOnBehalfOf(onBehalfOf));
    }

    public EndpointReferenceType getIssuer() {
        return this.issuer;
    }

    public void setIssuer(EndpointReferenceType issuer) {
        this.issuer = issuer;
        this.delegate.getAny().add(this.factory.createIssuer(issuer));
    }

    public URI getAuthenticationType() {
        return this.authenticationType;
    }

    public void setAuthenticationType(URI authenticationType) {
        this.authenticationType = authenticationType;
        this.delegate.getAny().add(this.factory.createAuthenticationType(authenticationType.toString()));
    }

    public URI getKeyType() {
        return this.keyType;
    }

    public void setKeyType(URI keyType) {
        this.keyType = keyType;
        this.delegate.getAny().add(this.factory.createKeyType(keyType.toString()));
    }

    public long getKeySize() {
        return this.keySize;
    }

    public void setKeySize(long keySize) {
        this.keySize = keySize;
        this.delegate.getAny().add(this.factory.createKeySize(keySize));
    }

    public URI getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void setSignatureAlgorithm(URI signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
        this.delegate.getAny().add(this.factory.createSignatureAlgorithm(signatureAlgorithm.toString()));
    }

    public EncryptionType getEncryption() {
        return this.encryption;
    }

    public void setEncryption(EncryptionType encryption) {
        this.encryption = encryption;
        this.delegate.getAny().add(this.factory.createEncryption(encryption));
    }

    public URI getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public void setEncryptionAlgorithm(URI encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.delegate.getAny().add(this.factory.createEncryptionAlgorithm(encryptionAlgorithm.toString()));
    }

    public URI getCanonicalizationAlgorithm() {
        return this.canonicalizationAlgorithm;
    }

    public void setCanonicalizationAlgorithm(URI canonicalizationAlgorithm) {
        this.canonicalizationAlgorithm = canonicalizationAlgorithm;
        this.delegate.getAny().add(this.factory.createCanonicalizationAlgorithm(canonicalizationAlgorithm.toString()));
    }

    public URI getKeyWrapAlgorithm() {
        return this.keyWrapAlgorithm;
    }

    public void setKeyWrapAlgorithm(URI keyWrapAlgorithm) {
        this.keyWrapAlgorithm = keyWrapAlgorithm;
    }

    public ProofEncryptionType getProofEncryption() {
        return this.proofEncryption;
    }

    public void setProofEncryption(ProofEncryptionType proofEncryption) {
        this.proofEncryption = proofEncryption;
        this.delegate.getAny().add(this.factory.createProofEncryption(proofEncryption));
    }

    public UseKeyType getUseKey() {
        return this.useKey;
    }

    public void setUseKey(UseKeyType useKey) {
        this.useKey = useKey;
        this.delegate.getAny().add(this.factory.createUseKey(useKey));
    }

    public URI getSignWith() {
        return this.signWith;
    }

    public void setSignWith(URI signWith) {
        this.signWith = signWith;
        this.delegate.getAny().add(this.factory.createSignatureAlgorithm(signWith.toString()));
    }

    public URI getEncryptWith() {
        return this.encryptWith;
    }

    public void setEncryptWith(URI encryptWith) {
        this.encryptWith = encryptWith;
        this.delegate.getAny().add(this.factory.createEncryptWith(encryptWith.toString()));
    }

    public DelegateToType getDelegateTo() {
        return this.delegateTo;
    }

    public void setDelegateTo(DelegateToType delegateTo) {
        this.delegateTo = delegateTo;
        this.delegate.getAny().add(this.factory.createDelegateTo(delegateTo));
    }

    public boolean isForwardable() {
        return this.forwardable;
    }

    public void setForwardable(boolean forwardable) {
        this.forwardable = forwardable;
        this.delegate.getAny().add(this.factory.createForwardable(forwardable));
    }

    public boolean isDelegatable() {
        return this.delegatable;
    }

    public void setDelegatable(boolean delegatable) {
        this.delegatable = delegatable;
        this.delegate.getAny().add(this.factory.createDelegatable(delegatable));
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public void setPolicy(Policy policy) {
        this.policy = policy;
        this.delegate.getAny().add(policy);
    }

    public PolicyReference getPolicyReference() {
        return this.policyReference;
    }

    public void setPolicyReference(PolicyReference policyReference) {
        this.policyReference = policyReference;
        this.delegate.getAny().add(policyReference);
    }

    public List<Object> getExtensionElements() {
        return Collections.unmodifiableList(this.extensionElements);
    }

    public String getContext() {
        return this.delegate.getContext();
    }

    public void setContext(String context) {
        this.delegate.setContext(context);
    }

    public CancelTargetType getCancelTarget() {
        return this.cancelTarget;
    }

    public void setCancelTarget(CancelTargetType cancelTarget) {
        this.cancelTarget = cancelTarget;
        this.delegate.getAny().add(this.factory.createCancelTarget(cancelTarget));
    }

    public RenewTargetType getRenewTarget() {
        return this.renewTarget;
    }

    public void setRenewTarget(RenewTargetType renewTarget) {
        this.renewTarget = renewTarget;
        this.delegate.getAny().add(this.factory.createRenewTarget(renewTarget));
    }

    public ValidateTargetType getValidateTarget() {
        return this.validateTarget;
    }

    public Element getValidateTargetElement() {
        if (this.rstDocument == null) {
            throw new IllegalStateException("RST Document is null");
        }
        String ns = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
        String localPart = "ValidateTarget";
        NodeList nodeList = this.rstDocument.getElementsByTagNameNS(ns, localPart);
        if (nodeList != null && nodeList.getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    public Element getRenewTargetElement() {
        if (this.rstDocument == null) {
            throw new IllegalStateException("RST Document is null");
        }
        String ns = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
        String localName = "RenewTarget";
        NodeList nodeList = this.rstDocument.getElementsByTagNameNS(ns, localName);
        if (nodeList != null && nodeList.getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    public Element getCancelTargetElement() {
        if (this.rstDocument == null) {
            throw new IllegalStateException("RST Document is null");
        }
        String ns = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
        String localName = "CancelTarget";
        NodeList nodeList = this.rstDocument.getElementsByTagNameNS(ns, localName);
        if (nodeList != null && nodeList.getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    public void setValidateTarget(ValidateTargetType validateTarget) {
        this.validateTarget = validateTarget;
        this.delegate.getAny().add(this.factory.createValidateTarget(validateTarget));
    }

    public Map<QName, String> getOtherAttributes() {
        return this.delegate.getOtherAttributes();
    }

    public List<Object> getAny() {
        return this.delegate.getAny();
    }

    public RequestSecurityTokenType getDelegate() {
        return this.delegate;
    }

    public Document getRSTDocument() {
        return this.rstDocument;
    }

    public void setRSTDocument(Document rstDocument) {
        this.rstDocument = rstDocument;
    }
}

