/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust.wrappers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.wstrust.wrappers.BaseRequestSecurityToken;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityToken;
import org.picketlink.identity.federation.ws.trust.RequestSecurityTokenCollectionType;
import org.picketlink.identity.federation.ws.trust.RequestSecurityTokenType;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestSecurityTokenCollection
implements BaseRequestSecurityToken {
    private final RequestSecurityTokenCollectionType delegate;
    private final List<RequestSecurityToken> requestSecurityTokens;

    public RequestSecurityTokenCollection() {
        this.requestSecurityTokens = new ArrayList<RequestSecurityToken>();
        this.delegate = new RequestSecurityTokenCollectionType();
    }

    public RequestSecurityTokenCollection(RequestSecurityTokenCollectionType delegate) {
        this.delegate = delegate;
        this.requestSecurityTokens = new ArrayList<RequestSecurityToken>();
        for (RequestSecurityTokenType request : delegate.getRequestSecurityToken()) {
            this.requestSecurityTokens.add(new RequestSecurityToken(request));
        }
    }

    public RequestSecurityTokenCollection(RequestSecurityTokenCollectionType delegate, Document document) {
        this.delegate = delegate;
        this.requestSecurityTokens = new ArrayList<RequestSecurityToken>();
        for (RequestSecurityTokenType request : delegate.getRequestSecurityToken()) {
            this.requestSecurityTokens.add(new RequestSecurityToken(request));
        }
        NodeList list = document.getElementsByTagNameNS("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "RequestSecurityToken");
        try {
            for (int i = 0; i < list.getLength(); ++i) {
                Document doc = DocumentUtil.createDocument();
                doc.appendChild(doc.importNode(list.item(i), true));
                this.requestSecurityTokens.get(i).setRSTDocument(doc);
            }
        }
        catch (ConfigurationException ce) {
            throw new RuntimeException("Error creating document: " + ce.getMessage(), ce);
        }
    }

    public List<RequestSecurityToken> getRequestSecurityTokens() {
        return Collections.unmodifiableList(this.requestSecurityTokens);
    }

    public void addRequestSecurityToken(RequestSecurityToken request) {
        this.delegate.getRequestSecurityToken().add(request.getDelegate());
        this.requestSecurityTokens.add(request);
    }

    public void removeRequestSecurityToken(RequestSecurityToken request) {
        this.delegate.getRequestSecurityToken().remove(request.getDelegate());
        this.requestSecurityTokens.remove(request);
    }

    public RequestSecurityTokenCollectionType getDelegate() {
        return this.delegate;
    }
}

