/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.openid;

import java.io.IOException;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.api.openid.OpenIDAttributeMap;
import org.picketlink.identity.federation.api.openid.OpenIDLifecycle;
import org.picketlink.identity.federation.api.openid.OpenIDLifecycleEvent;
import org.picketlink.identity.federation.api.openid.OpenIDProtocolAdapter;
import org.picketlink.identity.federation.api.openid.exceptions.OpenIDLifeCycleException;
import org.picketlink.identity.federation.api.openid.exceptions.OpenIDProtocolException;
import org.picketlink.identity.federation.web.openid.HTTPOpenIDContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPProtocolAdaptor
implements OpenIDProtocolAdapter,
OpenIDLifecycle {
    private static Logger log = Logger.getLogger(HTTPProtocolAdaptor.class);
    private boolean trace = log.isTraceEnabled();
    private HttpServletRequest request;
    private HttpServletResponse response;
    private ServletContext servletContext;
    private String returnURL;

    public HTTPProtocolAdaptor(HTTPOpenIDContext octx) {
        if (octx == null) {
            throw new IllegalArgumentException("http openid context is null");
        }
        this.request = octx.getRequest();
        this.response = octx.getResponse();
        this.returnURL = octx.getReturnURL();
        this.servletContext = octx.getServletContext();
    }

    @Override
    public OpenIDAttributeMap getAttributeMap() {
        OpenIDAttributeMap map = new OpenIDAttributeMap();
        if ("1".equals(this.request.getParameter("nickname"))) {
            map.put("nickname", "1");
        }
        if ("1".equals(this.request.getParameter("email"))) {
            map.put("email", "1");
        }
        if ("1".equals(this.request.getParameter("fullname"))) {
            map.put("fullname", "1");
        }
        if ("1".equals(this.request.getParameter("dob"))) {
            map.put("dob", "1");
        }
        if ("1".equals(this.request.getParameter("gender"))) {
            map.put("gender", "1");
        }
        if ("1".equals(this.request.getParameter("postcode"))) {
            map.put("postcode", "1");
        }
        if ("1".equals(this.request.getParameter("country"))) {
            map.put("country", "1");
        }
        if ("1".equals(this.request.getParameter("language"))) {
            map.put("language", "1");
        }
        if ("1".equals(this.request.getParameter("timezone"))) {
            map.put("timezone", "1");
        }
        return map;
    }

    @Override
    public String getReturnURL() {
        return this.returnURL;
    }

    @Override
    public void handle(OpenIDLifecycleEvent event) throws OpenIDLifeCycleException {
        if (event == null) {
            throw new IllegalArgumentException("event is null");
        }
        if (event.getEventType() == OpenIDLifecycleEvent.TYPE.SESSION) {
            String attr = event.getAttributeName();
            Object attrVal = event.getAttributeValue();
            if (event.getOperation() == OpenIDLifecycleEvent.OP.ADD) {
                this.request.getSession().setAttribute(attr, attrVal);
            } else if (event.getOperation() == OpenIDLifecycleEvent.OP.REMOVE) {
                this.request.getSession().removeAttribute(attr);
            }
        }
        if (event.getEventType() == OpenIDLifecycleEvent.TYPE.SUCCESS) {
            try {
                this.response.sendRedirect(".");
            }
            catch (IOException e) {
                throw new OpenIDLifeCycleException(e);
            }
        }
    }

    @Override
    public void handle(OpenIDLifecycleEvent[] eventArr) throws OpenIDLifeCycleException {
        for (OpenIDLifecycleEvent ev : eventArr) {
            this.handle(ev);
        }
    }

    @Override
    public void sendToProvider(int version, String destinationURL, Map<String, String> paramMap) throws OpenIDProtocolException {
        if (this.trace) {
            log.trace((Object)("send to provider=" + version + "::destinationURL=" + destinationURL));
        }
        if (version == 1) {
            try {
                this.response.sendRedirect(destinationURL);
                return;
            }
            catch (IOException e) {
                throw new OpenIDProtocolException(e);
            }
        }
        RequestDispatcher dispatcher = this.servletContext.getRequestDispatcher("/formredirection.jsp");
        this.request.setAttribute("parameterMap", paramMap);
        this.request.setAttribute("destinationUrl", (Object)destinationURL);
        try {
            dispatcher.forward((ServletRequest)this.request, (ServletResponse)this.response);
        }
        catch (IOException io) {
            throw new OpenIDProtocolException(io);
        }
        catch (ServletException e) {
            throw new OpenIDProtocolException(e);
        }
    }

    @Override
    public Object getAttributeValue(String name) {
        return this.request.getSession().getAttribute(name);
    }
}

