/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.ui.federation.idp;

import java.util.List;
import org.jboss.as.console.client.shared.deployment.model.DeploymentRecord;
import org.jboss.ballroom.client.widgets.forms.CheckBoxItem;
import org.jboss.ballroom.client.widgets.forms.ComboBoxItem;
import org.jboss.ballroom.client.widgets.forms.FormItem;
import org.jboss.ballroom.client.widgets.forms.TextBoxItem;
import org.jboss.ballroom.client.widgets.forms.TextItem;
import org.picketlink.as.console.client.i18n.PicketLinkUIConstants;
import org.picketlink.as.console.client.shared.subsys.model.GenericFederationEntity;
import org.picketlink.as.console.client.shared.subsys.model.IdentityProvider;
import org.picketlink.as.console.client.ui.federation.AbstractFederationDetailEditor;
import org.picketlink.as.console.client.ui.federation.AbstractFederationWizard;
import org.picketlink.as.console.client.ui.federation.FederationPresenter;
import org.picketlink.as.console.client.ui.federation.Wizard;
import org.picketlink.as.console.client.ui.federation.idp.IdentityProviderEditor;

public class NewIdentityProviderWizard<T extends GenericFederationEntity>
extends AbstractFederationWizard<T>
implements Wizard<T> {
    private ComboBoxItem aliasesItem;
    private TextItem editAliasesItem;
    private ComboBoxItem deploymentsItem;
    private CheckBoxItem externalIDP;
    private CheckBoxItem strictPostBinding;
    private ComboBoxItem securityDomainsItem;
    private TextBoxItem attributeManagerItem;
    private TextBoxItem roleGeneratorItem;
    private PicketLinkUIConstants uiConstants;

    public NewIdentityProviderWizard(AbstractFederationDetailEditor<T> editor, Class<T> cls, FederationPresenter presenter, String type, PicketLinkUIConstants uiConstants) {
        super(editor, cls, presenter, type, "alias", "security-domain", "url", "strict-post-binding", "attribute-manager", "role-generator");
        this.uiConstants = uiConstants;
    }

    @Override
    protected FormItem<?>[] doGetCustomFields() {
        ComboBoxItem aliasItem = null;
        if (!this.isDialogue()) {
            aliasItem = this.deploymentsItem = new ComboBoxItem("name", "Alias");
            this.updateAliasComboBox(aliasItem, this.getPresenter().getAllDeployments());
            aliasItem.setEnabled(false);
            aliasItem.setRequired(false);
        } else {
            aliasItem = this.getAliasItem();
            aliasItem.setRequired(true);
            this.updateAliasItems();
        }
        FormItem[] formItems = null;
        this.securityDomainsItem = new ComboBoxItem("securityDomain", "Security Domain");
        this.updateSecurityDomains();
        this.strictPostBinding = new CheckBoxItem("strictPostBinding", "Strict Post Binding");
        this.strictPostBinding.setEnabled(true);
        if (this.isDialogue()) {
            this.externalIDP = new CheckBoxItem("external", "Is external?"){

                @Override
                protected void doValueChange() {
                    if (this.getValue() != null && this.getValue().booleanValue()) {
                        NewIdentityProviderWizard.this.getAliasItem().setEnabled(false);
                        NewIdentityProviderWizard.this.getAliasItem().setRequired(false);
                        NewIdentityProviderWizard.this.securityDomainsItem.setEnabled(false);
                        NewIdentityProviderWizard.this.securityDomainsItem.setRequired(false);
                        NewIdentityProviderWizard.this.strictPostBinding.setEnabled(false);
                        NewIdentityProviderWizard.this.strictPostBinding.setRequired(false);
                    } else {
                        NewIdentityProviderWizard.this.getAliasItem().setEnabled(true);
                        NewIdentityProviderWizard.this.getAliasItem().setRequired(true);
                        NewIdentityProviderWizard.this.securityDomainsItem.setEnabled(true);
                        NewIdentityProviderWizard.this.securityDomainsItem.setRequired(true);
                        NewIdentityProviderWizard.this.strictPostBinding.setEnabled(true);
                        NewIdentityProviderWizard.this.strictPostBinding.setRequired(true);
                    }
                }
            };
            formItems = new FormItem[]{this.externalIDP, aliasItem, this.securityDomainsItem, new TextBoxItem("url", this.uiConstants.common_label_URL(), false)};
        } else {
            this.editAliasesItem = new TextItem("name", "Alias");
            this.editAliasesItem.setEnabled(false);
            this.attributeManagerItem = new TextBoxItem("attributeManager", "Attribute Manager");
            this.attributeManagerItem.setRequired(false);
            this.attributeManagerItem.setEnabled(true);
            this.roleGeneratorItem = new TextBoxItem("roleGenerator", "Role Generator");
            this.roleGeneratorItem.setRequired(false);
            this.roleGeneratorItem.setEnabled(true);
            formItems = new FormItem[]{this.editAliasesItem, this.securityDomainsItem, new TextBoxItem("url", this.uiConstants.common_label_URL(), true), this.strictPostBinding, this.attributeManagerItem, this.roleGeneratorItem};
        }
        return formItems;
    }

    private void updateSecurityDomains() {
        if (this.getPresenter().getSecurityDomains() != null && this.securityDomainsItem != null) {
            String[] securityDomains = new String[this.getPresenter().getSecurityDomains().size()];
            for (int i = 0; i < this.getPresenter().getSecurityDomains().size(); ++i) {
                securityDomains[i] = this.getPresenter().getSecurityDomains().get(i).getName();
            }
            this.securityDomainsItem.setValueMap(securityDomains);
        }
        if (!this.isDialogue() && this.getIdentityProviderEditor().getCurrentSelection() != null) {
            this.securityDomainsItem.setValue(((IdentityProvider)this.getIdentityProviderEditor().getCurrentSelection()).getSecurityDomain());
        }
    }

    private ComboBoxItem getAliasItem() {
        if (this.aliasesItem == null) {
            this.aliasesItem = new ComboBoxItem("name", "Alias");
        }
        return this.aliasesItem;
    }

    public void updateAliasItems() {
        if (this.getPresenter().getIdentityProvider() != null) {
            boolean isHosted = !this.getPresenter().getIdentityProvider().getIdentityProvider().isExternal();
            this.attributeManagerItem.setEnabled(isHosted);
            this.roleGeneratorItem.setEnabled(isHosted);
            this.strictPostBinding.setEnabled(isHosted);
        }
        if (this.deploymentsItem != null) {
            this.updateAliasComboBox(this.deploymentsItem, this.getPresenter().getAllDeployments());
        }
        this.updateAliasComboBox(this.getAliasItem(), this.getPresenter().getAvailableDeployments());
        if (this.getPresenter().getIdentityProvider() != null && this.getPresenter().getIdentityProvider().getIdentityProvider() != null && this.getPresenter().getIdentityProvider().getIdentityProvider().isExternal()) {
            this.editAliasesItem.setEnabled(false);
            this.securityDomainsItem.setEnabled(false);
        }
        this.updateSecurityDomains();
    }

    private void updateAliasComboBox(ComboBoxItem aliasItem, List<DeploymentRecord> deployments) {
        if (this.getPresenter().getAllDeployments() == null) {
            return;
        }
        String[] aliases = new String[deployments.size()];
        for (int i = 0; i < deployments.size(); ++i) {
            aliases[i] = deployments.get(i).getName();
        }
        aliasItem.setValueMap(aliases);
        if (!this.isDialogue() && this.getIdentityProviderEditor().getCurrentSelection() != null) {
            aliasItem.setValue(((IdentityProvider)this.getIdentityProviderEditor().getCurrentSelection()).getName());
        }
    }

    public IdentityProviderEditor getIdentityProviderEditor() {
        return (IdentityProviderEditor)this.getEditor();
    }

    public boolean isExternalIDP() {
        return this.externalIDP != null && this.externalIDP.getValue() != false;
    }
}

