/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.ui.federation;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.console.client.Console;
import org.jboss.as.console.client.domain.model.SimpleCallback;
import org.jboss.as.console.client.widgets.forms.FormToolStrip;
import org.jboss.ballroom.client.widgets.forms.Form;
import org.jboss.ballroom.client.widgets.forms.FormItem;
import org.jboss.ballroom.client.widgets.forms.PasswordBoxItem;
import org.jboss.ballroom.client.widgets.forms.TextBoxItem;
import org.jboss.ballroom.client.widgets.tools.ToolButton;
import org.picketlink.as.console.client.i18n.PicketLinkUIConstants;
import org.picketlink.as.console.client.shared.subsys.model.KeyStore;
import org.picketlink.as.console.client.shared.subsys.model.KeyStoreWrapper;
import org.picketlink.as.console.client.shared.subsys.model.ServiceProviderWrapper;
import org.picketlink.as.console.client.ui.federation.FederationPresenter;
import org.picketlink.as.console.client.ui.federation.KeyEditor;

public class DigitalCertificateDetails {
    private final PicketLinkUIConstants uiConstants;
    private TextBoxItem signKeyAliasItem;
    private final Form<KeyStore> form = new Form(KeyStore.class);
    private final FederationPresenter presenter;
    private boolean hasKeyStore;
    private ToolButton deleteButton;
    private KeyEditor keyEditor;

    public DigitalCertificateDetails(FederationPresenter presenter, PicketLinkUIConstants uiConstants) {
        this.presenter = presenter;
        this.uiConstants = uiConstants;
    }

    public Widget asWidget() {
        VerticalPanel layout = new VerticalPanel();
        layout.setStyleName("rhs-content-panel");
        TextBoxItem pathItem = new TextBoxItem("url", "KeyStore Path");
        pathItem.getInputElement().getStyle().setWidth(300.0, Style.Unit.PX);
        final TextBoxItem relativeToItem = new TextBoxItem("relativeTo", "Path Relative To");
        relativeToItem.getInputElement().getStyle().setWidth(300.0, Style.Unit.PX);
        relativeToItem.setRequired(false);
        PasswordBoxItem passwdItem = new PasswordBoxItem("passwd", "KeyStore Password");
        passwdItem.getInputElement().getStyle().setWidth(150.0, Style.Unit.PX);
        this.signKeyAliasItem = new TextBoxItem("signKeyAlias", "Signing Key Alias");
        this.signKeyAliasItem.getInputElement().getStyle().setWidth(150.0, Style.Unit.PX);
        PasswordBoxItem signKeyPasswdItem = new PasswordBoxItem("signKeyPasswd", "Signing Key Password");
        signKeyPasswdItem.getInputElement().getStyle().setWidth(150.0, Style.Unit.PX);
        this.form.setFields(new FormItem[]{pathItem, relativeToItem, passwdItem, this.signKeyAliasItem, signKeyPasswdItem});
        this.form.setEnabled(false);
        FormToolStrip toolStrip = new FormToolStrip(this.form, (FormToolStrip.FormCallback)new FormToolStrip.FormCallback<KeyStore>(){

            public void onSave(Map<String, Object> changeset) {
                KeyStore updatedEntity = (KeyStore)DigitalCertificateDetails.this.form.getUpdatedEntity();
                if (relativeToItem.getValue() != null && relativeToItem.getValue().isEmpty()) {
                    updatedEntity.setRelativeTo(null);
                }
                if (!DigitalCertificateDetails.this.hasKeyStore) {
                    DigitalCertificateDetails.this.presenter.getFederationManager().onCreateKeyStore(updatedEntity, new SimpleCallback<Boolean>(){

                        public void onSuccess(Boolean aBoolean) {
                            DigitalCertificateDetails.this.hasKeyStore = aBoolean;
                            DigitalCertificateDetails.this.deleteButton.setEnabled(true);
                        }
                    });
                } else {
                    DigitalCertificateDetails.this.presenter.getFederationManager().onUpdateKeyStore(updatedEntity, changeset);
                }
                DigitalCertificateDetails.this.form.edit((Object)updatedEntity);
            }

            public void onDelete(KeyStore keyStore) {
            }
        });
        this.deleteButton = new ToolButton(Console.CONSTANTS.common_label_delete());
        this.deleteButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                if (DigitalCertificateDetails.this.hasKeyStore) {
                    DigitalCertificateDetails.this.presenter.getFederationManager().onRemoveKeyStore((KeyStore)DigitalCertificateDetails.this.form.getEditedEntity());
                    DigitalCertificateDetails.this.form.clearValues();
                    DigitalCertificateDetails.this.hasKeyStore = false;
                    DigitalCertificateDetails.this.form.edit(DigitalCertificateDetails.this.presenter.getBeanFactory().keyStore().as());
                    DigitalCertificateDetails.this.signKeyAliasItem.setEnabled(true);
                    if (DigitalCertificateDetails.this.presenter.getCurrentFederation().getIdentityProvider() != null) {
                        DigitalCertificateDetails.this.presenter.getCurrentFederation().getIdentityProvider().getIdentityProvider().setSupportsSignatures(true);
                        HashMap<String, Object> changedValues = new HashMap<String, Object>();
                        changedValues.put("supportsSignatures", "false");
                        DigitalCertificateDetails.this.presenter.getFederationManager().onUpdateIdentityProvider(DigitalCertificateDetails.this.presenter.getCurrentFederation().getIdentityProvider().getIdentityProvider(), changedValues);
                        List<ServiceProviderWrapper> serviceProviders = DigitalCertificateDetails.this.presenter.getCurrentFederation().getServiceProviders();
                        for (ServiceProviderWrapper serviceProvider : serviceProviders) {
                            DigitalCertificateDetails.this.presenter.getFederationManager().onUpdateServiceProvider(serviceProvider.getServiceProvider(), changedValues);
                        }
                    }
                }
            }
        });
        toolStrip.addToolButtonRight(this.deleteButton);
        this.deleteButton.setEnabled(false);
        this.form.edit(this.presenter.getBeanFactory().keyStore().as());
        layout.add(toolStrip.asWidget());
        layout.add(this.form.asWidget());
        layout.add(this.getKeyEditor().asWidget());
        return layout;
    }

    private KeyEditor getKeyEditor() {
        if (this.keyEditor == null) {
            this.keyEditor = new KeyEditor(this.presenter, this.uiConstants);
        }
        return this.keyEditor;
    }

    public void setKeyStore(KeyStoreWrapper keyStore) {
        boolean bl = this.hasKeyStore = keyStore != null;
        if (keyStore != null) {
            this.signKeyAliasItem.setEnabled(false);
            this.deleteButton.setEnabled(true);
            this.form.edit((Object)keyStore.getKeyStore());
            this.getKeyEditor().setEnabled(true);
            this.getKeyEditor().getKeyTable().setList(keyStore.getKeys());
        } else {
            this.form.clearValues();
            this.signKeyAliasItem.setEnabled(true);
            this.deleteButton.setEnabled(false);
            this.form.edit(this.presenter.getBeanFactory().keyStore().as());
            this.getKeyEditor().setEnabled(false);
        }
    }
}

